/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XAnnotationValues;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMemberContainer;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeKt;

public final class AnnotationExpression {
    private final XAnnotation annotation;
    private final XClassName creatorClass;

    AnnotationExpression(XAnnotation annotation) {
        this.annotation = annotation;
        this.creatorClass = AnnotationExpression.getAnnotationCreatorClassName(annotation.getType().getTypeElement());
    }

    XCodeBlock getAnnotationInstanceExpression() {
        return this.getAnnotationInstanceExpression(this.annotation);
    }

    private XCodeBlock getAnnotationInstanceExpression(XAnnotation annotation) {
        return XCodeBlock.of((String)"%T.%L(%L)", (Object[])new Object[]{this.creatorClass, AnnotationExpression.createMethodName(annotation.getType().getTypeElement()), XCodeBlocks.makeParametersCodeBlock((Iterable)annotation.getAnnotationValues().stream().map(this::getValueExpression).collect(DaggerStreams.toImmutableList()))});
    }

    public static XClassName getAnnotationCreatorClassName(XTypeElement annotationType) {
        XClassName annotationTypeName = annotationType.asClassName();
        return XClassName.Companion.get(annotationTypeName.getPackageName(), new String[]{SourceFiles.classFileName(annotationTypeName) + "Creator"});
    }

    public static String createMethodName(XTypeElement annotationType) {
        return "create" + XElements.getSimpleName((XMemberContainer)annotationType);
    }

    XCodeBlock getValueExpression(XAnnotationValue value) {
        if (XTypeKt.isArray((XType)value.getValueType())) {
            XType componentType = XTypes.asArray(value.getValueType()).getComponentType();
            return XCodeBlock.of((String)"new %T[] {%L}", (Object[])new Object[]{XTypes.isTypeOf(componentType, XTypeNames.KCLASS) ? XTypeNames.CLASS : componentType.getRawType().asTypeName(), value.asAnnotationValueList().stream().map(this::getValueExpression).collect(XCodeBlocks.toParametersCodeBlock())});
        }
        if (value.hasEnumValue()) {
            return XCodeBlock.of((String)"%T.%L", (Object[])new Object[]{value.asEnum().getEnclosingElement().asClassName(), XElements.getSimpleName((XElement)value.asEnum())});
        }
        if (value.hasAnnotationValue()) {
            return this.getAnnotationInstanceExpression(value.asAnnotation());
        }
        if (value.hasTypeValue()) {
            return XCodeBlock.of((String)"%T.class", (Object[])new Object[]{value.asType().getTypeElement().asClassName()});
        }
        if (value.hasStringValue()) {
            return XCodeBlock.of((String)"%S", (Object[])new Object[]{value.asString()});
        }
        if (value.hasByteValue()) {
            return XCodeBlock.of((String)"(byte) %L", (Object[])new Object[]{value.asByte()});
        }
        if (value.hasCharValue()) {
            return XCodeBlock.of((String)"%L", (Object[])new Object[]{XAnnotationValues.characterLiteralWithSingleQuotes(value.asChar())});
        }
        if (value.hasDoubleValue()) {
            return XCodeBlock.of((String)"%LD", (Object[])new Object[]{value.asDouble()});
        }
        if (value.hasFloatValue()) {
            return XCodeBlock.of((String)"%LF", (Object[])new Object[]{Float.valueOf(value.asFloat())});
        }
        if (value.hasLongValue()) {
            return XCodeBlock.of((String)"%LL", (Object[])new Object[]{value.asLong()});
        }
        if (value.hasShortValue()) {
            return XCodeBlock.of((String)"(short) %L", (Object[])new Object[]{value.asShort()});
        }
        return XCodeBlock.of((String)"%L", (Object[])new Object[]{value.getValue()});
    }
}

