/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public final class SourceFileHjarGenerator<T>
extends SourceFileGenerator<T> {
    private final SourceFileGenerator<T> delegate;
    private final XProcessingEnv processingEnv;

    public static <T> SourceFileGenerator<T> wrap(SourceFileGenerator<T> delegate, XProcessingEnv processingEnv) {
        return new SourceFileHjarGenerator<T>(delegate, processingEnv);
    }

    private SourceFileHjarGenerator(SourceFileGenerator<T> delegate, XProcessingEnv processingEnv) {
        super(delegate);
        this.delegate = delegate;
        this.processingEnv = processingEnv;
    }

    @Override
    public XElement originatingElement(T input) {
        return this.delegate.originatingElement(input);
    }

    @Override
    public ImmutableList<XTypeSpec> topLevelTypes(T input) {
        String packageName = XElements.closestEnclosingTypeElement(this.originatingElement(input)).getPackageName();
        return (ImmutableList)this.delegate.topLevelTypes(input).stream().map(completeType -> this.skeletonType(packageName, XConverters.toJavaPoet((XTypeSpec)completeType))).collect(DaggerStreams.toImmutableList());
    }

    private XTypeSpec skeletonType(String packageName, TypeSpec completeType) {
        XTypeSpecs.Builder skeleton = XTypeSpecs.classBuilder(completeType.name).addJavaSuperinterfaces(completeType.superinterfaces).addJavaTypeVariableNames(completeType.typeVariables).addModifiers(completeType.modifiers.toArray(new Modifier[0])).addJavaAnnotations(completeType.annotations);
        if (!completeType.superclass.equals((Object)ClassName.OBJECT)) {
            skeleton.superclass(completeType.superclass);
        }
        completeType.methodSpecs.stream().filter(method -> !method.modifiers.contains((Object)Modifier.PRIVATE) || method.isConstructor()).map(completeMethod -> this.skeletonMethod(packageName, completeType, (MethodSpec)completeMethod)).forEach(skeleton::addMethod);
        completeType.fieldSpecs.stream().filter(field -> !field.modifiers.contains((Object)Modifier.PRIVATE)).map(this::skeletonField).forEach(skeleton::addField);
        completeType.typeSpecs.stream().map(type -> this.skeletonType(packageName, (TypeSpec)type)).forEach(skeleton::addType);
        completeType.alwaysQualifiedNames.forEach(skeleton::alwaysQualify);
        return skeleton.build();
    }

    private MethodSpec skeletonMethod(String packageName, TypeSpec completeType, MethodSpec completeMethod) {
        MethodSpec.Builder skeleton;
        MethodSpec.Builder builder = skeleton = completeMethod.isConstructor() ? MethodSpec.constructorBuilder() : MethodSpec.methodBuilder((String)completeMethod.name).returns(completeMethod.returnType);
        if (completeMethod.isConstructor()) {
            this.getRequiredSuperCall(packageName, completeType).ifPresent(superCall -> skeleton.addStatement("$L", new Object[]{superCall}));
        } else if (!completeMethod.returnType.equals((Object)XConverters.toJavaPoet((XTypeName)XTypeName.UNIT_VOID))) {
            skeleton.addStatement("return $L", new Object[]{SourceFileHjarGenerator.getDefaultValueCodeBlock(completeMethod.returnType)});
        }
        return skeleton.addModifiers((Iterable)completeMethod.modifiers).addTypeVariables((Iterable)completeMethod.typeVariables).addParameters((Iterable)completeMethod.parameters).addExceptions((Iterable)completeMethod.exceptions).varargs(completeMethod.varargs).addAnnotations((Iterable)completeMethod.annotations).build();
    }

    private Optional<CodeBlock> getRequiredSuperCall(String packageName, TypeSpec completeType) {
        if (completeType.superclass.equals((Object)XConverters.toJavaPoet((XTypeName)XTypeName.ANY_OBJECT))) {
            return Optional.empty();
        }
        ClassName rawSuperClass = (ClassName)XTypeNames.rawJavaTypeName(completeType.superclass);
        XTypeElement superTypeElement = this.processingEnv.requireTypeElement(rawSuperClass.canonicalName());
        ImmutableSet accessibleConstructors = (ImmutableSet)superTypeElement.getConstructors().stream().filter(constructor -> constructor.isProtected() || Accessibility.isElementAccessibleFrom((XElement)constructor, packageName)).collect(DaggerStreams.toImmutableSet());
        if (accessibleConstructors.isEmpty() || accessibleConstructors.stream().anyMatch(constructor -> constructor.getParameters().isEmpty())) {
            return Optional.empty();
        }
        return Optional.of(CodeBlock.of((String)"super($L)", (Object[])new Object[]{CodeBlocks.makeParametersCodeBlock((Iterable)((XConstructorElement)accessibleConstructors.stream().findFirst().get()).getParameters().stream().map(XVariableElement::getType).map(XType::getTypeName).map(SourceFileHjarGenerator::getDefaultValueCodeBlock).collect(DaggerStreams.toImmutableList()))}));
    }

    private static CodeBlock getDefaultValueCodeBlock(TypeName typeName) {
        if (typeName.isPrimitive()) {
            if (typeName.equals((Object)XConverters.toJavaPoet((XTypeName)XTypeName.PRIMITIVE_BOOLEAN))) {
                return CodeBlock.of((String)"false", (Object[])new Object[0]);
            }
            if (typeName.equals((Object)XConverters.toJavaPoet((XTypeName)XTypeName.PRIMITIVE_CHAR))) {
                return CodeBlock.of((String)"'\u0000'", (Object[])new Object[0]);
            }
            if (typeName.equals((Object)XConverters.toJavaPoet((XTypeName)XTypeName.PRIMITIVE_BYTE))) {
                return CodeBlock.of((String)"0", (Object[])new Object[0]);
            }
            if (typeName.equals((Object)XConverters.toJavaPoet((XTypeName)XTypeName.PRIMITIVE_SHORT))) {
                return CodeBlock.of((String)"0", (Object[])new Object[0]);
            }
            if (typeName.equals((Object)XConverters.toJavaPoet((XTypeName)XTypeName.PRIMITIVE_INT))) {
                return CodeBlock.of((String)"0", (Object[])new Object[0]);
            }
            if (typeName.equals((Object)XConverters.toJavaPoet((XTypeName)XTypeName.PRIMITIVE_LONG))) {
                return CodeBlock.of((String)"0L", (Object[])new Object[0]);
            }
            if (typeName.equals((Object)XConverters.toJavaPoet((XTypeName)XTypeName.PRIMITIVE_FLOAT))) {
                return CodeBlock.of((String)"0.0f", (Object[])new Object[0]);
            }
            if (typeName.equals((Object)XConverters.toJavaPoet((XTypeName)XTypeName.PRIMITIVE_DOUBLE))) {
                return CodeBlock.of((String)"0.0d", (Object[])new Object[0]);
            }
            throw new AssertionError((Object)("Unexpected type: " + typeName));
        }
        return CodeBlock.of((String)"null", (Object[])new Object[0]);
    }

    private FieldSpec skeletonField(FieldSpec completeField) {
        FieldSpec.Builder skeleton = FieldSpec.builder((TypeName)completeField.type, (String)completeField.name, (Modifier[])completeField.modifiers.toArray(new Modifier[0])).addAnnotations((Iterable)completeField.annotations);
        if (completeField.modifiers.contains((Object)Modifier.FINAL)) {
            skeleton.initializer(SourceFileHjarGenerator.getDefaultValueCodeBlock(completeField.type));
        }
        return skeleton.build();
    }
}

