/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.Set;

public final class FrameworkTypes {
    private static final ImmutableSet<XClassName> PROVISION_TYPES = ImmutableSet.of((Object)XTypeNames.PROVIDER, (Object)XTypeNames.JAKARTA_PROVIDER, (Object)XTypeNames.LAZY, (Object)XTypeNames.MEMBERS_INJECTOR);
    private static final ImmutableSet<XClassName> PRODUCTION_TYPES = ImmutableSet.of((Object)XTypeNames.PRODUCED, (Object)XTypeNames.PRODUCER);
    private static final ImmutableSet<XClassName> ALL_FRAMEWORK_TYPES = ImmutableSet.builder().addAll(PROVISION_TYPES).addAll(PRODUCTION_TYPES).build();
    public static final ImmutableSet<XClassName> SET_VALUE_FRAMEWORK_TYPES = ImmutableSet.of((Object)XTypeNames.PRODUCED);
    public static final ImmutableSet<XClassName> MAP_VALUE_FRAMEWORK_TYPES = ImmutableSet.of((Object)XTypeNames.PRODUCED, (Object)XTypeNames.PRODUCER, (Object)XTypeNames.PROVIDER, (Object)XTypeNames.JAKARTA_PROVIDER);
    private static final ImmutableSet<XClassName> DISALLOWED_TYPES = ImmutableSet.of((Object)XTypeNames.DAGGER_PROVIDER);

    public static boolean isProducerType(XType type) {
        return FrameworkTypes.typeIsOneOf(PRODUCTION_TYPES, type);
    }

    public static boolean isFrameworkType(XType type) {
        return FrameworkTypes.typeIsOneOf(ALL_FRAMEWORK_TYPES, type);
    }

    public static boolean isSetValueFrameworkType(XType type) {
        return FrameworkTypes.typeIsOneOf(SET_VALUE_FRAMEWORK_TYPES, type);
    }

    public static boolean isMapValueFrameworkType(XType type) {
        return FrameworkTypes.typeIsOneOf(MAP_VALUE_FRAMEWORK_TYPES, type);
    }

    public static boolean isDisallowedType(XType type) {
        return FrameworkTypes.typeIsOneOf(DISALLOWED_TYPES, type);
    }

    private static boolean typeIsOneOf(Set<XClassName> classNames, XType type) {
        return classNames.stream().anyMatch(className -> XTypes.isTypeOf(type, className));
    }

    private FrameworkTypes() {
    }
}

