/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XExpression;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.Optional;
import javax.lang.model.element.Modifier;

final class ProducerEntryPointView {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final XProcessingEnv processingEnv;

    ProducerEntryPointView(ComponentImplementation.ShardImplementation shardImplementation, XProcessingEnv processingEnv) {
        this.shardImplementation = shardImplementation;
        this.processingEnv = processingEnv;
    }

    Optional<XExpression> getProducerEntryPointField(RequestRepresentation producerExpression, ComponentDescriptor.ComponentMethodDescriptor componentMethod, XClassName requestingClass) {
        if (this.shardImplementation.componentDescriptor().isProduction() && (componentMethod.dependencyRequest().get().kind().equals((Object)RequestKind.FUTURE) || componentMethod.dependencyRequest().get().kind().equals((Object)RequestKind.PRODUCER))) {
            MemberSelect field = this.createField(producerExpression, componentMethod);
            return Optional.of(XExpression.create(this.fieldType(componentMethod), field.getExpressionFor(requestingClass)));
        }
        return Optional.empty();
    }

    private MemberSelect createField(RequestRepresentation producerExpression, ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        String methodName = XElements.getSimpleName((XElement)componentMethod.methodElement());
        FieldSpec field = FieldSpec.builder((TypeName)this.fieldType(componentMethod).getTypeName(), (String)this.shardImplementation.getUniqueFieldName(methodName + "EntryPoint"), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        this.shardImplementation.addField(ComponentImplementation.FieldSpecKind.FRAMEWORK_FIELD, field);
        XCodeBlock fieldInitialization = XCodeBlock.of((String)"this.%N = %T.entryPointViewOf(%L, %L);", (Object[])new Object[]{field.name, XTypeNames.PRODUCERS, producerExpression.getDependencyExpression(this.shardImplementation.name()).codeBlock(), XCodeBlocks.toXPoet(this.shardImplementation.isComponentShard() ? CodeBlock.of((String)"this", (Object[])new Object[0]) : this.shardImplementation.getComponentImplementation().getComponentShard().shardFieldReference())});
        this.shardImplementation.addInitialization(XConverters.toJavaPoet((XCodeBlock)fieldInitialization));
        return MemberSelect.localField(this.shardImplementation, field.name);
    }

    private XType fieldType(ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        return XProcessingEnvs.wrapType(XTypeNames.PRODUCER, componentMethod.dependencyRequest().get().key().type().xprocessing(), this.processingEnv);
    }
}

