/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.ComponentDependencyProvisionBinding;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentProvisionRequestRepresentation;
import dagger.internal.codegen.writing.ComponentRequirementExpressions;
import dagger.internal.codegen.writing.FrameworkFieldInitializer;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import javax.lang.model.element.Modifier;

final class DependencyMethodProviderCreationExpression
implements FrameworkFieldInitializer.FrameworkInstanceCreationExpression {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final ComponentRequirementExpressions componentRequirementExpressions;
    private final CompilerOptions compilerOptions;
    private final BindingGraph graph;
    private final ComponentDependencyProvisionBinding binding;
    private final XMethodElement provisionMethod;

    @AssistedInject
    DependencyMethodProviderCreationExpression(@Assisted ComponentDependencyProvisionBinding binding, ComponentImplementation componentImplementation, ComponentRequirementExpressions componentRequirementExpressions, CompilerOptions compilerOptions, BindingGraph graph) {
        this.binding = (ComponentDependencyProvisionBinding)Preconditions.checkNotNull((Object)binding);
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.componentRequirementExpressions = componentRequirementExpressions;
        this.compilerOptions = compilerOptions;
        this.graph = graph;
        Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        Preconditions.checkArgument((boolean)XElementKt.isMethod((XElement)binding.bindingElement().get()));
        this.provisionMethod = XElements.asMethod(binding.bindingElement().get());
    }

    @Override
    public CodeBlock creationExpression() {
        CodeBlock invocation = ComponentProvisionRequestRepresentation.maybeCheckForNull(this.binding, this.compilerOptions, CodeBlock.of((String)"$N.$N()", (Object[])new Object[]{this.dependency().variableName(), this.provisionMethod.getJvmName()}));
        XClassName dependencyClassName = this.dependency().typeElement().asClassName();
        XTypeName keyType = this.binding.key().type().xprocessing().asTypeName();
        MethodSpec.Builder getMethod = MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(XConverters.toJavaPoet((XTypeName)XTypeNames.withTypeNullability(keyType, this.binding.nullability()))).addStatement("return $L", new Object[]{invocation});
        this.binding.nullability().nonTypeUseNullableAnnotations().stream().map(XConverters::toJavaPoet).forEach(arg_0 -> ((MethodSpec.Builder)getMethod).addAnnotation(arg_0));
        ComponentImplementation.ShardImplementation componentShard = this.shardImplementation.getComponentImplementation().getComponentShard();
        XClassName factoryClassName = componentShard.name().nestedClass(componentShard.getUniqueClassName(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, XElements.getSimpleName((XElement)this.provisionMethod) + "Provider")));
        componentShard.addType(ComponentImplementation.TypeSpecKind.COMPONENT_PROVISION_FACTORY, TypeSpec.classBuilder((ClassName)XConverters.toJavaPoet((XClassName)factoryClassName)).addSuperinterface(XConverters.toJavaPoet((XTypeName)XTypeNames.daggerProviderOf(XTypeNames.withTypeNullability(keyType, this.binding.nullability())))).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addField((TypeName)XConverters.toJavaPoet((XClassName)dependencyClassName), this.dependency().variableName(), new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)XConverters.toJavaPoet((XClassName)dependencyClassName), this.dependency().variableName(), new Modifier[0]).addStatement("this.$1L = $1L", new Object[]{this.dependency().variableName()}).build()).addMethod(getMethod.build()).build());
        return CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{XConverters.toJavaPoet((XClassName)factoryClassName), this.componentRequirementExpressions.getExpressionDuringInitialization(this.dependency(), this.shardImplementation.name())});
    }

    private ComponentRequirement dependency() {
        return this.graph.componentDescriptor().getDependencyThatDefinesMethod((XElement)this.provisionMethod);
    }

    @AssistedFactory
    static interface Factory {
        public DependencyMethodProviderCreationExpression create(ComponentDependencyProvisionBinding var1);
    }
}

