/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.binding.BindingNode;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.Declaration;
import dagger.internal.codegen.binding.DeclarationFormatter;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.Binding;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DiagnosticReporter;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugin;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.tools.Diagnostic;

final class MapMultibindingValidator
extends ValidationBindingGraphPlugin {
    private final DeclarationFormatter declarationFormatter;
    private final KeyFactory keyFactory;

    @Inject
    MapMultibindingValidator(DeclarationFormatter declarationFormatter, KeyFactory keyFactory) {
        this.declarationFormatter = declarationFormatter;
        this.keyFactory = keyFactory;
    }

    @Override
    public String pluginName() {
        return "Dagger/MapKeys";
    }

    @Override
    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        this.mapMultibindings(bindingGraph).forEach(binding -> {
            ImmutableSet<ContributionBinding> contributions = this.mapBindingContributions((Binding)binding, bindingGraph);
            this.checkForDuplicateMapKeys((Binding)binding, contributions, diagnosticReporter);
            this.checkForInconsistentMapKeyAnnotationTypes((Binding)binding, contributions, diagnosticReporter);
        });
    }

    private ImmutableSet<Binding> mapMultibindings(BindingGraph bindingGraph) {
        HashSet visitedKeys = new HashSet();
        return (ImmutableSet)bindingGraph.bindings().stream().filter(binding -> binding.kind().equals((Object)BindingKind.MULTIBOUND_MAP)).sorted(Comparator.comparing(binding -> MapType.from(binding.key()).valueRequestKind())).filter(binding -> visitedKeys.add(this.unwrappedKey((Binding)binding))).collect(DaggerStreams.toImmutableSet());
    }

    private Key unwrappedKey(Binding binding) {
        return this.keyFactory.unwrapMapValueType(binding.key());
    }

    private ImmutableSet<ContributionBinding> mapBindingContributions(Binding binding, BindingGraph bindingGraph) {
        Preconditions.checkArgument((boolean)binding.kind().equals((Object)BindingKind.MULTIBOUND_MAP));
        return (ImmutableSet)bindingGraph.requestedBindings(binding).stream().map(b -> (BindingNode)b).map(b -> (ContributionBinding)b.delegate()).collect(DaggerStreams.toImmutableSet());
    }

    private void checkForDuplicateMapKeys(Binding multiboundMapBinding, ImmutableSet<ContributionBinding> contributions, DiagnosticReporter diagnosticReporter) {
        ImmutableSetMultimap contributionsByMapKey = ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(contributions, binding -> binding.mapKey().map(arg_0 -> XAnnotations.equivalence().wrap(arg_0))));
        for (Set contributionsForOneMapKey : Multimaps.asMap((SetMultimap)contributionsByMapKey).values()) {
            if (contributionsForOneMapKey.size() <= 1) continue;
            diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, multiboundMapBinding, this.duplicateMapKeyErrorMessage(contributionsForOneMapKey, multiboundMapBinding.key()));
        }
    }

    private void checkForInconsistentMapKeyAnnotationTypes(Binding multiboundMapBinding, ImmutableSet<ContributionBinding> contributions, DiagnosticReporter diagnosticReporter) {
        ImmutableSetMultimap contributionsByMapKeyAnnotationType = ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(contributions, mapBinding -> XAnnotations.asClassName(mapBinding.mapKey().get())));
        if (contributionsByMapKeyAnnotationType.keySet().size() > 1) {
            diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, multiboundMapBinding, this.inconsistentMapKeyAnnotationTypesErrorMessage((ImmutableSetMultimap<XClassName, ContributionBinding>)contributionsByMapKeyAnnotationType, multiboundMapBinding.key()));
        }
    }

    private String inconsistentMapKeyAnnotationTypesErrorMessage(ImmutableSetMultimap<XClassName, ContributionBinding> contributionsByMapKeyAnnotationType, Key mapBindingKey) {
        StringBuilder message = new StringBuilder(mapBindingKey.toString()).append(" uses more than one @MapKey annotation type");
        Multimaps.asMap(contributionsByMapKeyAnnotationType).forEach((annotationType, contributions) -> {
            message.append('\n').append("    ").append(annotationType).append(':');
            this.declarationFormatter.formatIndentedList(message, contributions, 2);
        });
        return message.toString();
    }

    private String duplicateMapKeyErrorMessage(Set<ContributionBinding> contributionsForOneMapKey, Key mapBindingKey) {
        StringBuilder message = new StringBuilder("The same map key is bound more than once for ").append(mapBindingKey);
        this.declarationFormatter.formatIndentedList(message, ImmutableList.sortedCopyOf(Declaration.COMPARATOR, contributionsForOneMapKey), 1);
        return message.toString();
    }
}

