/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.base.ModuleKind;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeNameKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

public final class ModuleProxies {
    private ModuleProxies() {
    }

    private static ClassName constructorProxyTypeName(XTypeElement moduleElement) {
        ModuleKind.checkIsModule(moduleElement);
        XClassName moduleClassName = moduleElement.asClassName();
        return XTypeNameKt.toJavaPoet((XClassName)moduleClassName).topLevelClassName().peerClass(SourceFiles.classFileName(moduleClassName) + "_Proxy");
    }

    private static Optional<XConstructorElement> nonPublicNullaryConstructor(XTypeElement moduleElement) {
        ModuleKind.checkIsModule(moduleElement);
        if (moduleElement.isAbstract() || XTypeElements.isNested(moduleElement) && !moduleElement.isStatic()) {
            return Optional.empty();
        }
        return moduleElement.getConstructors().stream().filter(constructor -> !Accessibility.isElementPubliclyAccessible((XElement)constructor)).filter(constructor -> !constructor.isPrivate()).filter(constructor -> constructor.getParameters().isEmpty()).findAny();
    }

    public static CodeBlock newModuleInstance(XTypeElement moduleElement, ClassName requestingClass) {
        ModuleKind.checkIsModule(moduleElement);
        String packageName = requestingClass.packageName();
        return ModuleProxies.nonPublicNullaryConstructor(moduleElement).filter(constructor -> !Accessibility.isElementAccessibleFrom((XElement)constructor, packageName)).map(constructor -> CodeBlock.of((String)"$T.newInstance()", (Object[])new Object[]{ModuleProxies.constructorProxyTypeName(moduleElement)})).orElse(CodeBlock.of((String)"new $T()", (Object[])new Object[]{moduleElement.getClassName()}));
    }

    public static final class ModuleConstructorProxyGenerator
    extends SourceFileGenerator<XTypeElement> {
        @Inject
        ModuleConstructorProxyGenerator(XFiler filer, XProcessingEnv processingEnv) {
            super(filer, processingEnv);
        }

        @Override
        public XElement originatingElement(XTypeElement moduleElement) {
            return moduleElement;
        }

        @Override
        public ImmutableList<TypeSpec.Builder> topLevelTypes(XTypeElement moduleElement) {
            ModuleKind.checkIsModule(moduleElement);
            return ModuleProxies.nonPublicNullaryConstructor(moduleElement).isPresent() ? ImmutableList.of((Object)this.buildProxy(moduleElement)) : ImmutableList.of();
        }

        private TypeSpec.Builder buildProxy(XTypeElement moduleElement) {
            return TypeSpec.classBuilder((ClassName)ModuleProxies.constructorProxyTypeName(moduleElement)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build()).addMethod(MethodSpec.methodBuilder((String)"newInstance").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)moduleElement.getClassName()).addStatement("return new $T()", new Object[]{moduleElement.getClassName()}).build());
        }
    }
}

