/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.WildcardTypeName;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.binding.AutoValue_ComponentDeclarations_TypeNameKey;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.Declaration;
import dagger.internal.codegen.binding.DelegateDeclaration;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.binding.ModuleDescriptor;
import dagger.internal.codegen.binding.MultibindingDeclaration;
import dagger.internal.codegen.binding.OptionalBindingDeclaration;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.DaggerAnnotation;
import dagger.internal.codegen.model.Key;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import java.util.Optional;
import javax.inject.Inject;

final class ComponentDeclarations {
    private static final ImmutableSet<TypeName> MAP_FRAMEWORK_TYPENAMES = ImmutableSet.of((Object)TypeNames.PROVIDER, (Object)TypeNames.PRODUCER, (Object)TypeNames.PRODUCED);
    private static final ImmutableSet<TypeName> SET_FRAMEWORK_TYPENAMES = ImmutableSet.of((Object)TypeNames.PRODUCED);
    private final KeyFactory keyFactory;
    private final ImmutableSetMultimap<Key, ContributionBinding> bindings;
    private final ImmutableSetMultimap<Key, DelegateDeclaration> delegates;
    private final ImmutableSetMultimap<Key, OptionalBindingDeclaration> optionalBindings;
    private final ImmutableSetMultimap<Key, SubcomponentDeclaration> subcomponents;
    private final ImmutableSetMultimap<TypeNameKey, MultibindingDeclaration> multibindings;
    private final ImmutableSetMultimap<TypeNameKey, ContributionBinding> multibindingContributions;
    private final ImmutableSetMultimap<TypeNameKey, DelegateDeclaration> delegateMultibindingContributions;

    private ComponentDeclarations(KeyFactory keyFactory, ImmutableSetMultimap<Key, ContributionBinding> bindings, ImmutableSetMultimap<Key, DelegateDeclaration> delegates, ImmutableSetMultimap<Key, OptionalBindingDeclaration> optionalBindings, ImmutableSetMultimap<Key, SubcomponentDeclaration> subcomponents, ImmutableSetMultimap<TypeNameKey, MultibindingDeclaration> multibindings, ImmutableSetMultimap<TypeNameKey, ContributionBinding> multibindingContributions, ImmutableSetMultimap<TypeNameKey, DelegateDeclaration> delegateMultibindingContributions) {
        this.keyFactory = keyFactory;
        this.bindings = bindings;
        this.delegates = delegates;
        this.optionalBindings = optionalBindings;
        this.subcomponents = subcomponents;
        this.multibindings = multibindings;
        this.multibindingContributions = multibindingContributions;
        this.delegateMultibindingContributions = delegateMultibindingContributions;
    }

    ImmutableSet<ContributionBinding> bindings(Key key) {
        return this.bindings.get((Object)key);
    }

    ImmutableSet<DelegateDeclaration> delegates(Key key) {
        return this.delegates.get((Object)(key.multibindingContributionIdentifier().isPresent() ? this.keyFactory.unwrapMapValueType(key) : key));
    }

    ImmutableSet<DelegateDeclaration> delegateMultibindingContributions(Key key) {
        return this.delegateMultibindingContributions.get((Object)ComponentDeclarations.unwrapMultibindingKey(key));
    }

    ImmutableSet<MultibindingDeclaration> multibindings(Key key) {
        return this.multibindings.get((Object)ComponentDeclarations.unwrapMultibindingKey(key));
    }

    ImmutableSet<ContributionBinding> multibindingContributions(Key key) {
        return this.multibindingContributions.get((Object)ComponentDeclarations.unwrapMultibindingKey(key));
    }

    ImmutableSet<OptionalBindingDeclaration> optionalBindings(Key key) {
        return this.optionalBindings.get((Object)key);
    }

    ImmutableSet<SubcomponentDeclaration> subcomponents(Key key) {
        return this.subcomponents.get((Object)key);
    }

    ImmutableSet<Declaration> allDeclarations() {
        return ImmutableSet.builder().addAll((Iterable)this.bindings.values()).addAll((Iterable)this.delegates.values()).addAll((Iterable)this.multibindings.values()).addAll((Iterable)this.optionalBindings.values()).addAll((Iterable)this.subcomponents.values()).build();
    }

    private static TypeNameKey unwrapMultibindingKey(Key multibindingKey) {
        return TypeNameKey.from(multibindingKey.multibindingContributionIdentifier(), multibindingKey.qualifier(), ComponentDeclarations.unwrapMultibindingTypeName(multibindingKey.type().xprocessing().getTypeName()));
    }

    private static TypeName unwrapMultibindingTypeName(TypeName typeName) {
        if (ComponentDeclarations.isValidMapMultibindingTypeName(typeName)) {
            ParameterizedTypeName mapTypeName = (ParameterizedTypeName)typeName;
            TypeName mapKeyTypeName = (TypeName)mapTypeName.typeArguments.get(0);
            TypeName mapValueTypeName = (TypeName)mapTypeName.typeArguments.get(1);
            return ParameterizedTypeName.get((ClassName)mapTypeName.rawType, (TypeName[])new TypeName[]{mapKeyTypeName, ComponentDeclarations.unwrapFrameworkTypeName(mapValueTypeName, MAP_FRAMEWORK_TYPENAMES)});
        }
        if (ComponentDeclarations.isValidSetMultibindingTypeName(typeName)) {
            ParameterizedTypeName setTypeName = (ParameterizedTypeName)typeName;
            TypeName setValueTypeName = (TypeName)Iterables.getOnlyElement((Iterable)setTypeName.typeArguments);
            return ParameterizedTypeName.get((ClassName)setTypeName.rawType, (TypeName[])new TypeName[]{ComponentDeclarations.unwrapFrameworkTypeName(setValueTypeName, SET_FRAMEWORK_TYPENAMES)});
        }
        return typeName;
    }

    private static boolean isValidMapMultibindingTypeName(TypeName typeName) {
        if (!(typeName instanceof ParameterizedTypeName)) {
            return false;
        }
        ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
        return parameterizedTypeName.rawType.equals((Object)TypeNames.MAP) && parameterizedTypeName.typeArguments.size() == 2 && !(parameterizedTypeName.typeArguments.get(0) instanceof WildcardTypeName) && !(parameterizedTypeName.typeArguments.get(1) instanceof WildcardTypeName);
    }

    private static boolean isValidSetMultibindingTypeName(TypeName typeName) {
        if (!(typeName instanceof ParameterizedTypeName)) {
            return false;
        }
        ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
        return parameterizedTypeName.rawType.equals((Object)TypeNames.SET) && parameterizedTypeName.typeArguments.size() == 1 && !(Iterables.getOnlyElement((Iterable)parameterizedTypeName.typeArguments) instanceof WildcardTypeName);
    }

    private static TypeName unwrapFrameworkTypeName(TypeName typeName, ImmutableSet<TypeName> frameworkTypeNames) {
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            if (frameworkTypeNames.contains((Object)parameterizedTypeName.rawType)) {
                typeName = (TypeName)Iterables.getOnlyElement((Iterable)parameterizedTypeName.typeArguments);
            }
        }
        return typeName;
    }

    @AutoValue
    static abstract class TypeNameKey {
        TypeNameKey() {
        }

        static TypeNameKey from(Optional<Key.MultibindingContributionIdentifier> multibindingContributionIdentifier, Optional<DaggerAnnotation> qualifier, TypeName typeName) {
            return new AutoValue_ComponentDeclarations_TypeNameKey(multibindingContributionIdentifier, qualifier, typeName);
        }

        abstract Optional<Key.MultibindingContributionIdentifier> multibindingContributionIdentifier();

        abstract Optional<DaggerAnnotation> qualifier();

        abstract TypeName type();
    }

    static final class Factory {
        private final XProcessingEnv processingEnv;
        private final KeyFactory keyFactory;
        private final ModuleDescriptor.Factory moduleDescriptorFactory;

        @Inject
        Factory(XProcessingEnv processingEnv, KeyFactory keyFactory, ModuleDescriptor.Factory moduleDescriptorFactory) {
            this.processingEnv = processingEnv;
            this.keyFactory = keyFactory;
            this.moduleDescriptorFactory = moduleDescriptorFactory;
        }

        ComponentDeclarations create(Optional<ComponentDescriptor> parentDescriptor, ComponentDescriptor descriptor) {
            ImmutableSet.Builder bindings = ImmutableSet.builder();
            ImmutableSet.Builder delegates = ImmutableSet.builder();
            ImmutableSet.Builder multibindings = ImmutableSet.builder();
            ImmutableSet.Builder optionalBindings = ImmutableSet.builder();
            ImmutableSet.Builder subcomponents = ImmutableSet.builder();
            bindings.addAll(descriptor.bindings());
            delegates.addAll(descriptor.delegateDeclarations());
            multibindings.addAll(descriptor.multibindingDeclarations());
            optionalBindings.addAll(descriptor.optionalBindingDeclarations());
            subcomponents.addAll(descriptor.subcomponentDeclarations());
            for (ModuleDescriptor module : this.implicitProductionModules(descriptor, parentDescriptor)) {
                bindings.addAll(module.bindings());
                delegates.addAll(module.delegateDeclarations());
                multibindings.addAll(module.multibindingDeclarations());
                optionalBindings.addAll(module.optionalDeclarations());
                subcomponents.addAll(module.subcomponentDeclarations());
            }
            return new ComponentDeclarations(this.keyFactory, Factory.indexDeclarationsByKey(bindings.build()), Factory.indexDeclarationsByKey(delegates.build()), Factory.indexDeclarationsByKey(optionalBindings.build()), Factory.indexDeclarationsByKey(subcomponents.build()), this.indexDeclarationsByUnwrappedMultibindingKey((Iterable)multibindings.build()), this.indexDeclarationsByUnwrappedMultibindingKey((Iterable)Factory.multibindingContributions(bindings.build())), this.indexDeclarationsByUnwrappedMultibindingKey((Iterable)Factory.multibindingContributions(delegates.build())));
        }

        private ImmutableSet<ModuleDescriptor> implicitProductionModules(ComponentDescriptor descriptor, Optional<ComponentDescriptor> parentDescriptor) {
            return Factory.shouldIncludeImplicitProductionModules(descriptor, parentDescriptor) ? ImmutableSet.of((Object)this.moduleDescriptorFactory.create(DaggerSuperficialValidation.requireTypeElement(this.processingEnv, SourceFiles.generatedMonitoringModuleName(descriptor.typeElement()))), (Object)this.moduleDescriptorFactory.create(this.processingEnv.requireTypeElement((TypeName)TypeNames.PRODUCTION_EXECTUTOR_MODULE))) : ImmutableSet.of();
        }

        private static boolean shouldIncludeImplicitProductionModules(ComponentDescriptor descriptor, Optional<ComponentDescriptor> parentDescriptor) {
            return descriptor.isProduction() && descriptor.isRealComponent() && (parentDescriptor.isEmpty() || !parentDescriptor.get().isProduction());
        }

        private static <T extends Declaration> ImmutableSetMultimap<Key, T> indexDeclarationsByKey(Iterable<T> declarations) {
            return ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(declarations, Declaration::key));
        }

        private <T extends Declaration> ImmutableSetMultimap<TypeNameKey, T> indexDeclarationsByUnwrappedMultibindingKey(Iterable<T> declarations) {
            return ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(declarations, declaration -> ComponentDeclarations.unwrapMultibindingKey(declaration.key().withoutMultibindingContributionIdentifier())));
        }

        private static <T extends Declaration> ImmutableSet<T> multibindingContributions(ImmutableSet<T> declarations) {
            return (ImmutableSet)declarations.stream().filter(declaration -> declaration.key().multibindingContributionIdentifier().isPresent()).collect(DaggerStreams.toImmutableSet());
        }
    }
}

