/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.processingstep;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.ComponentCreatorAnnotation;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.BindingGraphFactory;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.processingstep.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.BindingGraphValidator;
import dagger.internal.codegen.validation.ComponentCreatorValidator;
import dagger.internal.codegen.validation.ComponentDescriptorValidator;
import dagger.internal.codegen.validation.ComponentValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;

final class ComponentProcessingStep
extends TypeCheckingProcessingStep<XTypeElement> {
    private final XMessager messager;
    private final ComponentValidator componentValidator;
    private final ComponentCreatorValidator creatorValidator;
    private final ComponentDescriptorValidator componentDescriptorValidator;
    private final ComponentDescriptor.Factory componentDescriptorFactory;
    private final BindingGraphFactory bindingGraphFactory;
    private final SourceFileGenerator<dagger.internal.codegen.binding.BindingGraph> componentGenerator;
    private final BindingGraphValidator bindingGraphValidator;

    @Inject
    ComponentProcessingStep(XMessager messager, ComponentValidator componentValidator, ComponentCreatorValidator creatorValidator, ComponentDescriptorValidator componentDescriptorValidator, ComponentDescriptor.Factory componentDescriptorFactory, BindingGraphFactory bindingGraphFactory, SourceFileGenerator<dagger.internal.codegen.binding.BindingGraph> componentGenerator, BindingGraphValidator bindingGraphValidator) {
        this.messager = messager;
        this.componentValidator = componentValidator;
        this.creatorValidator = creatorValidator;
        this.componentDescriptorValidator = componentDescriptorValidator;
        this.componentDescriptorFactory = componentDescriptorFactory;
        this.bindingGraphFactory = bindingGraphFactory;
        this.componentGenerator = componentGenerator;
        this.bindingGraphValidator = bindingGraphValidator;
    }

    @Override
    public Set<ClassName> annotationClassNames() {
        return Sets.union(ComponentAnnotation.allComponentAnnotations(), ComponentCreatorAnnotation.allCreatorAnnotations());
    }

    @Override
    protected void process(XTypeElement element, ImmutableSet<ClassName> annotations) {
        if (!Collections.disjoint(annotations, ComponentAnnotation.rootComponentAnnotations())) {
            this.processRootComponent(element);
        }
        if (!Collections.disjoint(annotations, ComponentAnnotation.subcomponentAnnotations())) {
            this.processSubcomponent(element);
        }
        if (!Collections.disjoint(annotations, ComponentCreatorAnnotation.allCreatorAnnotations())) {
            this.processCreator(element);
        }
    }

    private void processRootComponent(XTypeElement component) {
        if (!this.isComponentValid(component)) {
            return;
        }
        ComponentDescriptor componentDescriptor = this.componentDescriptorFactory.rootComponentDescriptor(component);
        if (!this.isValid(componentDescriptor)) {
            return;
        }
        Supplier fullBindingGraphSupplier = Suppliers.memoize(() -> this.bindingGraphFactory.create(componentDescriptor, true).topLevelBindingGraph());
        if (this.bindingGraphValidator.shouldDoFullBindingGraphValidation(component) && !this.bindingGraphValidator.isValid((BindingGraph)fullBindingGraphSupplier.get())) {
            return;
        }
        dagger.internal.codegen.binding.BindingGraph bindingGraph = this.bindingGraphFactory.create(componentDescriptor, false);
        if (this.bindingGraphValidator.isValid(bindingGraph.topLevelBindingGraph(), (Supplier<BindingGraph>)fullBindingGraphSupplier)) {
            this.generateComponent(bindingGraph);
        }
    }

    private void processSubcomponent(XTypeElement subcomponent) {
        if (!this.isComponentValid(subcomponent)) {
            return;
        }
        ComponentDescriptor subcomponentDescriptor = this.componentDescriptorFactory.subcomponentDescriptor(subcomponent);
        if (!this.bindingGraphValidator.shouldDoFullBindingGraphValidation(subcomponent)) {
            return;
        }
        dagger.internal.codegen.binding.BindingGraph fullBindingGraph = this.bindingGraphFactory.create(subcomponentDescriptor, true);
        boolean unusedIsValid = this.bindingGraphValidator.isValid(fullBindingGraph.topLevelBindingGraph());
    }

    private void generateComponent(dagger.internal.codegen.binding.BindingGraph bindingGraph) {
        this.componentGenerator.generate(bindingGraph, this.messager);
    }

    private void processCreator(XTypeElement creator) {
        this.creatorValidator.validate(creator).printMessagesTo(this.messager);
    }

    private boolean isComponentValid(XTypeElement component) {
        ValidationReport report = this.componentValidator.validate(component);
        report.printMessagesTo(this.messager);
        return report.isClean();
    }

    private boolean isValid(ComponentDescriptor componentDescriptor) {
        ValidationReport componentDescriptorReport = this.componentDescriptorValidator.validate(componentDescriptor);
        componentDescriptorReport.printMessagesTo(this.messager);
        return componentDescriptorReport.isClean();
    }
}

