/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.FrameworkField;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.FrameworkInstanceSupplier;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.spi.model.BindingKind;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import java.util.Optional;
import javax.lang.model.element.Modifier;

class FrameworkFieldInitializer
implements FrameworkInstanceSupplier {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final ContributionBinding binding;
    private final FrameworkInstanceCreationExpression frameworkInstanceCreationExpression;
    private FieldSpec fieldSpec;
    private InitializationState fieldInitializationState = InitializationState.UNINITIALIZED;

    FrameworkFieldInitializer(ComponentImplementation componentImplementation, ContributionBinding binding, FrameworkInstanceCreationExpression frameworkInstanceCreationExpression) {
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.shardImplementation = ((ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation)).shardImplementation(binding);
        this.frameworkInstanceCreationExpression = (FrameworkInstanceCreationExpression)Preconditions.checkNotNull((Object)frameworkInstanceCreationExpression);
    }

    @Override
    public final MemberSelect memberSelect() {
        this.initializeField();
        return MemberSelect.localField(this.shardImplementation, ((FieldSpec)Preconditions.checkNotNull((Object)this.fieldSpec)).name);
    }

    private void initializeField() {
        switch (this.fieldInitializationState) {
            case UNINITIALIZED: {
                this.fieldInitializationState = InitializationState.INITIALIZING;
                CodeBlock.Builder codeBuilder = CodeBlock.builder();
                CodeBlock fieldInitialization = this.frameworkInstanceCreationExpression.creationExpression();
                CodeBlock initCode = CodeBlock.of((String)"this.$N = $L;", (Object[])new Object[]{this.getOrCreateField(), fieldInitialization});
                if (this.fieldInitializationState == InitializationState.DELEGATED) {
                    codeBuilder.add("$T.setDelegate($N, $L);", new Object[]{this.delegateType(), this.fieldSpec, fieldInitialization});
                } else {
                    codeBuilder.add(initCode);
                }
                this.shardImplementation.addInitialization(codeBuilder.build());
                this.fieldInitializationState = InitializationState.INITIALIZED;
                break;
            }
            case INITIALIZING: {
                this.fieldSpec = this.getOrCreateField();
                this.fieldInitializationState = InitializationState.DELEGATED;
                this.shardImplementation.addInitialization(CodeBlock.of((String)"this.$N = new $T<>();", (Object[])new Object[]{this.fieldSpec, this.delegateType()}));
                break;
            }
        }
    }

    private FieldSpec getOrCreateField() {
        ParameterizedTypeName fieldType;
        if (this.fieldSpec != null) {
            return this.fieldSpec;
        }
        boolean useRawType = !this.shardImplementation.isTypeAccessible(this.binding.key().type().xprocessing());
        FrameworkField contributionBindingField = FrameworkField.forBinding(this.binding, this.frameworkInstanceCreationExpression.alternativeFrameworkClass());
        Object object = fieldType = useRawType ? contributionBindingField.type().rawType : contributionBindingField.type();
        if (this.binding.kind() == BindingKind.ASSISTED_INJECTION) {
            TypeName[] typeParameters = (TypeName[])this.binding.key().type().xprocessing().getTypeArguments().stream().map(XType::getTypeName).toArray(TypeName[]::new);
            fieldType = typeParameters.length == 0 ? SourceFiles.generatedClassNameForBinding(this.binding) : ParameterizedTypeName.get((ClassName)SourceFiles.generatedClassNameForBinding(this.binding), (TypeName[])typeParameters);
        }
        FieldSpec.Builder contributionField = FieldSpec.builder((TypeName)fieldType, (String)this.shardImplementation.getUniqueFieldName(contributionBindingField.name()), (Modifier[])new Modifier[0]);
        contributionField.addModifiers(new Modifier[]{Modifier.PRIVATE});
        if (useRawType) {
            contributionField.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0]));
        }
        this.fieldSpec = contributionField.build();
        this.shardImplementation.addField(ComponentImplementation.FieldSpecKind.FRAMEWORK_FIELD, this.fieldSpec);
        return this.fieldSpec;
    }

    private ClassName delegateType() {
        return this.isProvider() ? TypeNames.DELEGATE_FACTORY : TypeNames.DELEGATE_PRODUCER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isProvider() {
        if (!this.binding.bindingType().equals((Object)BindingType.PROVISION)) return false;
        if (this.frameworkInstanceCreationExpression.alternativeFrameworkClass().map(arg_0 -> ((ClassName)TypeNames.PROVIDER).equals(arg_0)).orElse(true) == false) return false;
        return true;
    }

    private static enum InitializationState {
        UNINITIALIZED,
        INITIALIZING,
        DELEGATED,
        INITIALIZED;

    }

    static interface FrameworkInstanceCreationExpression {
        public CodeBlock creationExpression();

        default public Optional<ClassName> alternativeFrameworkClass() {
            return Optional.empty();
        }
    }
}

