/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.javapoet;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import java.util.stream.Collector;
import java.util.stream.StreamSupport;
import javax.lang.model.element.Modifier;

public final class CodeBlocks {
    public static Collector<CodeBlock, ?, CodeBlock> toParametersCodeBlock() {
        return CodeBlock.joining((String)", ");
    }

    public static Collector<CodeBlock, ?, CodeBlock> toConcatenatedCodeBlock() {
        return CodeBlock.joining((String)"\n", (String)"", (String)"\n");
    }

    public static CodeBlock makeParametersCodeBlock(Iterable<CodeBlock> codeBlocks) {
        return StreamSupport.stream(codeBlocks.spliterator(), false).collect(CodeBlocks.toParametersCodeBlock());
    }

    public static CodeBlock parameterNames(Iterable<ParameterSpec> parameters) {
        return StreamSupport.stream(parameters.spliterator(), false).map(p -> CodeBlock.of((String)"$N", (Object[])new Object[]{p})).collect(CodeBlocks.toParametersCodeBlock());
    }

    public static CodeBlock concat(Iterable<CodeBlock> codeBlocks) {
        return StreamSupport.stream(codeBlocks.spliterator(), false).collect(CodeBlocks.toConcatenatedCodeBlock());
    }

    public static CodeBlock anonymousProvider(Expression expression) {
        return CodeBlocks.anonymousProvider(expression.type().getTypeName(), CodeBlock.of((String)"return $L;", (Object[])new Object[]{expression.codeBlock()}));
    }

    public static CodeBlock anonymousProvider(TypeName providedType, CodeBlock body) {
        return CodeBlock.of((String)"$L", (Object[])new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)TypeNames.providerOf(providedType)).addMethod(MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(providedType).addCode(body).build()).build()});
    }

    public static CodeBlock cast(CodeBlock expression, ClassName castTo) {
        return CodeBlock.of((String)"($T) $L", (Object[])new Object[]{castTo, expression});
    }

    public static CodeBlock cast(CodeBlock expression, Class<?> castTo) {
        return CodeBlock.of((String)"($T) $L", (Object[])new Object[]{castTo, expression});
    }

    public static CodeBlock type(XType type) {
        return CodeBlock.of((String)"$T", (Object[])new Object[]{type.getTypeName()});
    }

    public static CodeBlock stringLiteral(String toWrap) {
        return CodeBlock.of((String)"$S", (Object[])new Object[]{toWrap});
    }

    private CodeBlocks() {
    }
}

