/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.base.Scopes;
import dagger.internal.codegen.binding.MethodSignatureFormatter;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.validation.DiagnosticMessageGenerator;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugin;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.model.Binding;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DaggerElement;
import dagger.spi.model.DiagnosticReporter;
import dagger.spi.model.Scope;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.tools.Diagnostic;

final class IncompatiblyScopedBindingsValidator
extends ValidationBindingGraphPlugin {
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final CompilerOptions compilerOptions;
    private final DiagnosticMessageGenerator.Factory diagnosticMessageGeneratorFactory;

    @Inject
    IncompatiblyScopedBindingsValidator(MethodSignatureFormatter methodSignatureFormatter, CompilerOptions compilerOptions, DiagnosticMessageGenerator.Factory diagnosticMessageGeneratorFactory) {
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.compilerOptions = compilerOptions;
        this.diagnosticMessageGeneratorFactory = diagnosticMessageGeneratorFactory;
    }

    public String pluginName() {
        return "Dagger/IncompatiblyScopedBindings";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        DiagnosticMessageGenerator diagnosticMessageGenerator = this.diagnosticMessageGeneratorFactory.create(bindingGraph);
        ImmutableSetMultimap.Builder incompatibleBindings = ImmutableSetMultimap.builder();
        for (Binding binding : bindingGraph.bindings()) {
            binding.scope().filter(scope -> !scope.isReusable()).ifPresent(scope -> {
                BindingGraph.ComponentNode componentNode = (BindingGraph.ComponentNode)bindingGraph.componentNode(binding.componentPath()).get();
                if (!componentNode.scopes().contains(scope)) {
                    if (binding.kind().equals((Object)BindingKind.INJECTION) && (bindingGraph.rootComponentNode().isSubcomponent() || !bindingGraph.rootComponentNode().isRealComponent())) {
                        return;
                    }
                    incompatibleBindings.put((Object)componentNode, (Object)binding);
                }
            });
        }
        Multimaps.asMap((SetMultimap)incompatibleBindings.build()).forEach((componentNode, bindings) -> this.report((BindingGraph.ComponentNode)componentNode, (Set<Binding>)bindings, diagnosticReporter, diagnosticMessageGenerator));
    }

    private void report(BindingGraph.ComponentNode componentNode, Set<Binding> bindings, DiagnosticReporter diagnosticReporter, DiagnosticMessageGenerator diagnosticMessageGenerator) {
        Diagnostic.Kind diagnosticKind = Diagnostic.Kind.ERROR;
        StringBuilder message = new StringBuilder(componentNode.componentPath().currentComponent().className().canonicalName());
        if (!componentNode.isRealComponent()) {
            if (bindings.stream().map(Binding::scope).map(Optional::get).distinct().count() <= 1L) {
                return;
            }
            message.append(" contains bindings with different scopes:");
            diagnosticKind = this.compilerOptions.moduleHasDifferentScopesDiagnosticKind();
        } else if (componentNode.scopes().isEmpty()) {
            message.append(" (unscoped) may not reference scoped bindings:");
        } else {
            message.append(" scoped with ").append(componentNode.scopes().stream().map(Scopes::getReadableSource).collect(Collectors.joining(" "))).append(" may not reference bindings with different scopes:");
        }
        for (Binding binding : bindings) {
            message.append('\n').append("    ");
            switch (binding.kind()) {
                case DELEGATE: 
                case PROVISION: {
                    message.append(this.methodSignatureFormatter.format(XElements.asExecutable((XElement)((DaggerElement)binding.bindingElement().get()).xprocessing())));
                    break;
                }
                case INJECTION: {
                    message.append(Scopes.getReadableSource((Scope)binding.scope().get())).append(" class ").append(XElements.closestEnclosingTypeElement((XElement)((DaggerElement)binding.bindingElement().get()).xprocessing()).getQualifiedName()).append(diagnosticMessageGenerator.getMessage((BindingGraph.MaybeBinding)binding));
                    break;
                }
                default: {
                    throw new AssertionError(binding);
                }
            }
            message.append('\n');
        }
        diagnosticReporter.reportComponent(diagnosticKind, componentNode, message.toString());
    }
}

