/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.CaseFormat;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.spi.model.RequestKind;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import java.util.Optional;

public enum FrameworkType {
    PROVIDER{

        @Override
        public CodeBlock to(RequestKind requestKind, CodeBlock from) {
            switch (requestKind) {
                case INSTANCE: {
                    return CodeBlock.of((String)"$L.get()", (Object[])new Object[]{from});
                }
                case LAZY: {
                    return CodeBlock.of((String)"$T.lazy($L)", (Object[])new Object[]{TypeNames.DOUBLE_CHECK, from});
                }
                case PROVIDER: {
                    return from;
                }
                case PROVIDER_OF_LAZY: {
                    return CodeBlock.of((String)"$T.create($L)", (Object[])new Object[]{TypeNames.PROVIDER_OF_LAZY, from});
                }
                case PRODUCER: {
                    return CodeBlock.of((String)"$T.producerFromProvider($L)", (Object[])new Object[]{TypeNames.PRODUCERS, from});
                }
                case FUTURE: {
                    return CodeBlock.of((String)"$T.immediateFuture($L)", (Object[])new Object[]{TypeNames.FUTURES, this.to(RequestKind.INSTANCE, from)});
                }
                case PRODUCED: {
                    return CodeBlock.of((String)"$T.successful($L)", (Object[])new Object[]{TypeNames.PRODUCED, this.to(RequestKind.INSTANCE, from)});
                }
            }
            throw new IllegalArgumentException(String.format("Cannot request a %s from a %s", new Object[]{requestKind, this}));
        }

        @Override
        public Expression to(RequestKind requestKind, Expression from, XProcessingEnv processingEnv) {
            CodeBlock codeBlock = this.to(requestKind, from.codeBlock());
            switch (requestKind) {
                case INSTANCE: {
                    return Expression.create(from.type().unwrapType(), codeBlock);
                }
                case PROVIDER: {
                    return from;
                }
                case PROVIDER_OF_LAZY: {
                    return Expression.create(from.type().rewrapType(TypeNames.LAZY).wrapType(TypeNames.PROVIDER), codeBlock);
                }
                case FUTURE: {
                    return Expression.create(from.type().rewrapType(TypeNames.LISTENABLE_FUTURE), codeBlock);
                }
            }
            return Expression.create(from.type().rewrapType(RequestKinds.frameworkClassName(requestKind)), codeBlock);
        }
    }
    ,
    PRODUCER_NODE{

        @Override
        public CodeBlock to(RequestKind requestKind, CodeBlock from) {
            switch (requestKind) {
                case FUTURE: {
                    return CodeBlock.of((String)"$L.get()", (Object[])new Object[]{from});
                }
                case PRODUCER: {
                    return from;
                }
            }
            throw new IllegalArgumentException(String.format("Cannot request a %s from a %s", new Object[]{requestKind, this}));
        }

        @Override
        public Expression to(RequestKind requestKind, Expression from, XProcessingEnv processingEnv) {
            switch (requestKind) {
                case FUTURE: {
                    return Expression.create(from.type().rewrapType(TypeNames.LISTENABLE_FUTURE), this.to(requestKind, from.codeBlock()));
                }
                case PRODUCER: {
                    return Expression.create(from.type(), this.to(requestKind, from.codeBlock()));
                }
            }
            throw new IllegalArgumentException(String.format("Cannot request a %s from a %s", new Object[]{requestKind, this}));
        }
    };


    public static FrameworkType forBindingType(BindingType bindingType) {
        switch (bindingType) {
            case PROVISION: {
                return PROVIDER;
            }
            case PRODUCTION: {
                return PRODUCER_NODE;
            }
        }
        throw new AssertionError((Object)bindingType);
    }

    public static Optional<FrameworkType> forRequestKind(RequestKind requestKind) {
        switch (requestKind) {
            case PROVIDER: {
                return Optional.of(PROVIDER);
            }
        }
        return Optional.empty();
    }

    public ClassName frameworkClassName() {
        switch (this) {
            case PROVIDER: {
                return TypeNames.PROVIDER;
            }
            case PRODUCER_NODE: {
                return TypeNames.PRODUCER;
            }
        }
        throw new AssertionError((Object)("Unknown value: " + this.name()));
    }

    public ParameterizedTypeName frameworkClassOf(TypeName valueType) {
        return ParameterizedTypeName.get((ClassName)this.frameworkClassName(), (TypeName[])new TypeName[]{valueType});
    }

    public RequestKind requestKind() {
        switch (this) {
            case PROVIDER: {
                return RequestKind.PROVIDER;
            }
            case PRODUCER_NODE: {
                return RequestKind.PRODUCER;
            }
        }
        throw new AssertionError((Object)("Unknown value: " + this.name()));
    }

    public abstract CodeBlock to(RequestKind var1, CodeBlock var2);

    public abstract Expression to(RequestKind var1, Expression var2, XProcessingEnv var3);

    public String toString() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, super.toString());
    }
}

