/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.binding.AutoValue_FrameworkField;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.model.BindingKind;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import java.util.Optional;

@AutoValue
public abstract class FrameworkField {
    public static FrameworkField create(ClassName frameworkClassName, TypeName valueTypeName, String fieldName) {
        String suffix = frameworkClassName.simpleName();
        return new AutoValue_FrameworkField(ParameterizedTypeName.get((ClassName)frameworkClassName, (TypeName[])new TypeName[]{valueTypeName}), fieldName.endsWith(suffix) ? fieldName : fieldName + suffix);
    }

    public static FrameworkField forBinding(ContributionBinding binding, Optional<ClassName> frameworkClassName) {
        return FrameworkField.create(frameworkClassName.orElse(binding.frameworkType().frameworkClassName()), FrameworkField.fieldValueType(binding).getTypeName(), FrameworkField.frameworkFieldName(binding));
    }

    private static XType fieldValueType(ContributionBinding binding) {
        return binding.contributionType().isMultibinding() ? binding.contributedType() : binding.key().type().xprocessing();
    }

    private static String frameworkFieldName(ContributionBinding binding) {
        if (binding.bindingElement().isPresent()) {
            String name = FrameworkField.bindingElementName(binding.bindingElement().get());
            return binding.kind().equals((Object)BindingKind.MEMBERS_INJECTOR) ? name + "MembersInjector" : name;
        }
        return KeyVariableNamer.name(binding.key());
    }

    private static String bindingElementName(XElement bindingElement) {
        if (XElementKt.isConstructor((XElement)bindingElement)) {
            return FrameworkField.bindingElementName(bindingElement.getEnclosingElement());
        }
        if (XElementKt.isMethod((XElement)bindingElement)) {
            return XElements.getSimpleName((XElement)bindingElement);
        }
        if (XElementKt.isTypeElement((XElement)bindingElement)) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, XElements.getSimpleName((XElement)bindingElement));
        }
        if (XElementKt.isMethodParameter((XElement)bindingElement)) {
            return XElements.getSimpleName((XElement)bindingElement);
        }
        throw new IllegalArgumentException("Unexpected binding " + bindingElement);
    }

    public abstract ParameterizedTypeName type();

    public abstract String name();
}

