/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import dagger.internal.codegen.compileroption.ProcessingOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.validation.DiagnosticReporterFactory;
import dagger.internal.codegen.validation.ExternalBindingGraphConverter;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import dagger.spi.model.BindingGraph;
import dagger.spi.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.tools.Diagnostic;

public final class ExternalBindingGraphPlugins {
    private final ImmutableSet<BindingGraphPlugin> plugins;
    private final DiagnosticReporterFactory diagnosticReporterFactory;
    private final XFiler filer;
    private final XProcessingEnv processingEnv;
    private final Map<String, String> processingOptions;

    @Inject
    ExternalBindingGraphPlugins(ImmutableSet<BindingGraphPlugin> plugins, DiagnosticReporterFactory diagnosticReporterFactory, XFiler filer, XProcessingEnv processingEnv, @ProcessingOptions Map<String, String> processingOptions) {
        this.plugins = plugins;
        this.diagnosticReporterFactory = diagnosticReporterFactory;
        this.filer = filer;
        this.processingEnv = processingEnv;
        this.processingOptions = processingOptions;
    }

    public ImmutableSet<String> allSupportedOptions() {
        return (ImmutableSet)this.plugins.stream().flatMap(plugin -> plugin.supportedOptions().stream()).collect(DaggerStreams.toImmutableSet());
    }

    public void initializePlugins() {
        this.plugins.forEach(this::initializePlugin);
    }

    private void initializePlugin(BindingGraphPlugin plugin) {
        plugin.initFiler(XConverters.toJavac((XFiler)this.filer));
        plugin.initTypes(XConverters.toJavac((XProcessingEnv)this.processingEnv).getTypeUtils());
        plugin.initElements(XConverters.toJavac((XProcessingEnv)this.processingEnv).getElementUtils());
        Set supportedOptions = plugin.supportedOptions();
        if (!supportedOptions.isEmpty()) {
            plugin.initOptions(Maps.filterKeys(this.processingOptions, supportedOptions::contains));
        }
    }

    boolean visit(BindingGraph spiGraph) {
        if (this.plugins.isEmpty()) {
            return true;
        }
        dagger.model.BindingGraph graph = ExternalBindingGraphConverter.fromSpiModel(spiGraph);
        boolean isClean = true;
        for (BindingGraphPlugin plugin : this.plugins) {
            DiagnosticReporterFactory.DiagnosticReporterImpl spiReporter = this.diagnosticReporterFactory.reporter(spiGraph, plugin.pluginName(), false);
            DiagnosticReporter reporter = ExternalBindingGraphConverter.fromSpiModel(spiReporter);
            plugin.visitGraph(graph, reporter);
            if (!spiReporter.reportedDiagnosticKinds().contains((Object)Diagnostic.Kind.ERROR)) continue;
            isClean = false;
        }
        return isClean;
    }

    public void endPlugins() {
        this.plugins.forEach(BindingGraphPlugin::onPluginEnd);
    }
}

