/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.CodeBlock;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.MethodRequestRepresentation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;

final class ComponentMethodRequestRepresentation
extends MethodRequestRepresentation {
    private final RequestRepresentation wrappedRequestRepresentation;
    private final ComponentImplementation componentImplementation;
    private final ComponentDescriptor.ComponentMethodDescriptor componentMethod;
    private final XProcessingEnv processingEnv;

    @AssistedInject
    ComponentMethodRequestRepresentation(@Assisted RequestRepresentation wrappedRequestRepresentation, @Assisted ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation componentImplementation, XProcessingEnv processingEnv) {
        super(componentImplementation.getComponentShard(), processingEnv);
        this.wrappedRequestRepresentation = (RequestRepresentation)Preconditions.checkNotNull((Object)wrappedRequestRepresentation);
        this.componentMethod = (ComponentDescriptor.ComponentMethodDescriptor)Preconditions.checkNotNull((Object)componentMethod);
        this.componentImplementation = componentImplementation;
        this.processingEnv = processingEnv;
    }

    @Override
    protected Expression getDependencyExpressionForComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation component) {
        return componentMethod.equals(this.componentMethod) && component.equals(this.componentImplementation) ? this.wrappedRequestRepresentation.getDependencyExpressionForComponentMethod(componentMethod, this.componentImplementation) : super.getDependencyExpressionForComponentMethod(componentMethod, component);
    }

    @Override
    protected CodeBlock methodCall() {
        return CodeBlock.of((String)"$N()", (Object[])new Object[]{XElements.getSimpleName((XElement)this.componentMethod.methodElement())});
    }

    @Override
    protected XType returnType() {
        return this.componentMethod.resolvedReturnType(this.processingEnv);
    }

    @AssistedFactory
    static interface Factory {
        public ComponentMethodRequestRepresentation create(RequestRepresentation var1, ComponentDescriptor.ComponentMethodDescriptor var2);
    }
}

