/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.validation.AnyBindingMethodValidator;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import javax.inject.Inject;

public final class BindingMethodProcessingStep
extends TypeCheckingProcessingStep<XMethodElement> {
    private final XMessager messager;
    private final AnyBindingMethodValidator anyBindingMethodValidator;

    @Inject
    BindingMethodProcessingStep(XMessager messager, AnyBindingMethodValidator anyBindingMethodValidator) {
        this.messager = messager;
        this.anyBindingMethodValidator = anyBindingMethodValidator;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return this.anyBindingMethodValidator.methodAnnotations();
    }

    @Override
    protected void process(XMethodElement method, ImmutableSet<ClassName> annotations) {
        Preconditions.checkArgument((boolean)this.anyBindingMethodValidator.isBindingMethod((XExecutableElement)method), (String)"%s is not annotated with any of %s", (Object)method, this.annotations());
        if (!this.anyBindingMethodValidator.wasAlreadyValidated(method)) {
            this.anyBindingMethodValidator.validate(method).printMessagesTo(this.messager);
        }
    }
}

