/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.DaggerGenerated;
import dagger.internal.codegen.base.SourceFileGenerationException;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Optional;

public abstract class SourceFileGenerator<T> {
    private static final String GENERATED_COMMENTS = "https://dagger.dev";
    private final XFiler filer;
    private final XProcessingEnv processingEnv;

    public SourceFileGenerator(XFiler filer, XProcessingEnv processingEnv) {
        this.filer = (XFiler)Preconditions.checkNotNull((Object)filer);
        this.processingEnv = (XProcessingEnv)Preconditions.checkNotNull((Object)processingEnv);
    }

    public SourceFileGenerator(SourceFileGenerator<T> delegate) {
        this(delegate.filer, delegate.processingEnv);
    }

    public void generate(T input, XMessager messager) {
        try {
            this.generate(input);
        }
        catch (SourceFileGenerationException e) {
            e.printMessageTo(messager);
        }
    }

    public void generate(T input) throws SourceFileGenerationException {
        for (TypeSpec.Builder type : this.topLevelTypes(input)) {
            try {
                this.buildJavaFile(input, type).writeTo(XConverters.toJavac((XFiler)this.filer));
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, SourceFileGenerationException.class);
                throw new SourceFileGenerationException(Optional.empty(), e, this.originatingElement(input));
            }
        }
    }

    private JavaFile buildJavaFile(T input, TypeSpec.Builder typeSpecBuilder) {
        XElement originatingElement = this.originatingElement(input);
        JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)typeSpecBuilder, (XElement)originatingElement);
        typeSpecBuilder.addAnnotation(DaggerGenerated.class);
        Optional<AnnotationSpec> generatedAnnotation = Optional.ofNullable(this.processingEnv.findGeneratedAnnotation()).map(annotation -> AnnotationSpec.builder((ClassName)annotation.getClassName()).addMember("value", "$S", new Object[]{"dagger.internal.codegen.ComponentProcessor"}).addMember("comments", "$S", new Object[]{GENERATED_COMMENTS}).build());
        generatedAnnotation.ifPresent(arg_0 -> ((TypeSpec.Builder)typeSpecBuilder).addAnnotation(arg_0));
        typeSpecBuilder.addAnnotation(AnnotationSpecs.suppressWarnings((ImmutableSet<AnnotationSpecs.Suppression>)ImmutableSet.builder().addAll(this.warningSuppressions()).add((Object[])new AnnotationSpecs.Suppression[]{AnnotationSpecs.Suppression.UNCHECKED, AnnotationSpecs.Suppression.RAWTYPES}).build()));
        String packageName = XElements.closestEnclosingTypeElement((XElement)originatingElement).getPackageName();
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)packageName, (TypeSpec)typeSpecBuilder.build()).skipJavaLangImports(true);
        if (!generatedAnnotation.isPresent()) {
            javaFileBuilder.addFileComment("Generated by Dagger ($L).", new Object[]{GENERATED_COMMENTS});
        }
        return javaFileBuilder.build();
    }

    public abstract XElement originatingElement(T var1);

    public abstract ImmutableList<TypeSpec.Builder> topLevelTypes(T var1);

    protected ImmutableSet<AnnotationSpecs.Suppression> warningSuppressions() {
        return ImmutableSet.of();
    }
}

