/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.xprocessing.XAnnotationValues;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import java.util.List;
import java.util.function.Predicate;

public final class MapKeyAccessibility {
    private MapKeyAccessibility() {
    }

    private static boolean checkAnnotation(XAnnotation annotation, Predicate<XType> accessibilityChecker) {
        return MapKeyAccessibility.checkValues(annotation.getAnnotationValues(), accessibilityChecker);
    }

    private static boolean checkValues(List<XAnnotationValue> values, Predicate<XType> accessibilityChecker) {
        return values.stream().allMatch(value -> MapKeyAccessibility.checkValue(value, accessibilityChecker));
    }

    private static boolean checkValue(XAnnotationValue value, Predicate<XType> accessibilityChecker) {
        if (XAnnotationValues.hasArrayValue((XAnnotationValue)value)) {
            return MapKeyAccessibility.checkValues(value.asAnnotationValueList(), accessibilityChecker);
        }
        if (XAnnotationValues.hasAnnotationValue((XAnnotationValue)value)) {
            return MapKeyAccessibility.checkAnnotation(value.asAnnotation(), accessibilityChecker);
        }
        if (XAnnotationValues.hasEnumValue((XAnnotationValue)value)) {
            return accessibilityChecker.test(value.asEnum().getEnclosingElement().getType());
        }
        if (XAnnotationValues.hasTypeValue((XAnnotationValue)value)) {
            return accessibilityChecker.test(value.asType());
        }
        return true;
    }

    public static boolean isMapKeyAccessibleFrom(XAnnotation annotation, String accessingPackage) {
        return MapKeyAccessibility.checkAnnotation(annotation, type -> Accessibility.isTypeAccessibleFrom(type, accessingPackage));
    }

    public static boolean isMapKeyPubliclyAccessible(XAnnotation annotation) {
        return MapKeyAccessibility.checkAnnotation(annotation, Accessibility::isTypePubliclyAccessible);
    }
}

