/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.binding.AutoValue_ComponentRequirement;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.model.BindingKind;
import dagger.spi.model.Key;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;

@AutoValue
public abstract class ComponentRequirement {
    private XType type;

    public abstract Kind kind();

    final boolean isBoundInstance() {
        return this.kind().isBoundInstance();
    }

    abstract TypeName typeName();

    public XType type() {
        return this.type;
    }

    public XTypeElement typeElement() {
        return this.type.getTypeElement();
    }

    abstract Optional<NullPolicy> overrideNullPolicy();

    public NullPolicy nullPolicy() {
        if (this.overrideNullPolicy().isPresent()) {
            return this.overrideNullPolicy().get();
        }
        switch (this.kind()) {
            case MODULE: {
                return ComponentRequirement.componentCanMakeNewInstances(this.typeElement()) ? NullPolicy.NEW : (this.requiresAPassedInstance() ? NullPolicy.THROW : NullPolicy.ALLOW);
            }
            case DEPENDENCY: 
            case BOUND_INSTANCE: {
                return NullPolicy.THROW;
            }
        }
        throw new AssertionError();
    }

    public boolean requiresAPassedInstance() {
        if (!this.kind().isModule()) {
            return true;
        }
        return this.requiresModuleInstance() && !ComponentRequirement.componentCanMakeNewInstances(this.typeElement());
    }

    private boolean requiresModuleInstance() {
        if (this.typeElement().isKotlinObject() || this.typeElement().isCompanionObject()) {
            return false;
        }
        return StreamsKt.asStream((Sequence)this.typeElement().getAllNonPrivateInstanceMethods()).filter(this::isBindingMethod).anyMatch(method -> !method.isAbstract() && !method.isStatic());
    }

    private boolean isBindingMethod(XMethodElement method) {
        return XElements.hasAnyAnnotation((XAnnotated)method, (ClassName[])new ClassName[]{TypeNames.PROVIDES, TypeNames.PRODUCES, TypeNames.BINDS, TypeNames.MULTIBINDS, TypeNames.BINDS_OPTIONAL_OF});
    }

    public abstract Optional<Key> key();

    public abstract String variableName();

    public ParameterSpec toParameterSpec() {
        return ParameterSpec.builder((TypeName)this.type().getTypeName(), (String)this.variableName(), (Modifier[])new Modifier[0]).build();
    }

    public static ComponentRequirement forDependency(XType type) {
        Preconditions.checkArgument((boolean)XTypes.isDeclared((XType)((XType)Preconditions.checkNotNull((Object)type))));
        AutoValue_ComponentRequirement requirement = new AutoValue_ComponentRequirement(Kind.DEPENDENCY, type.getTypeName(), Optional.empty(), Optional.empty(), SourceFiles.simpleVariableName(type.getTypeElement().getClassName()));
        requirement.type = type;
        return requirement;
    }

    public static ComponentRequirement forModule(XType type) {
        Preconditions.checkArgument((boolean)XTypes.isDeclared((XType)((XType)Preconditions.checkNotNull((Object)type))));
        AutoValue_ComponentRequirement requirement = new AutoValue_ComponentRequirement(Kind.MODULE, type.getTypeName(), Optional.empty(), Optional.empty(), SourceFiles.simpleVariableName(type.getTypeElement().getClassName()));
        requirement.type = type;
        return requirement;
    }

    static ComponentRequirement forBoundInstance(Key key, boolean nullable, XElement elementForVariableName) {
        AutoValue_ComponentRequirement requirement = new AutoValue_ComponentRequirement(Kind.BOUND_INSTANCE, key.type().xprocessing().getTypeName(), nullable ? Optional.of(NullPolicy.ALLOW) : Optional.empty(), Optional.of(key), XConverters.toJavac((XElement)elementForVariableName).getSimpleName().toString());
        requirement.type = key.type().xprocessing();
        return requirement;
    }

    public static ComponentRequirement forBoundInstance(ContributionBinding binding) {
        Preconditions.checkArgument((boolean)binding.kind().equals((Object)BindingKind.BOUND_INSTANCE));
        ComponentRequirement requirement = ComponentRequirement.forBoundInstance(binding.key(), binding.nullableType().isPresent(), binding.bindingElement().get());
        requirement.type = binding.key().type().xprocessing();
        return requirement;
    }

    public static boolean componentCanMakeNewInstances(XTypeElement typeElement) {
        switch (XConverters.toJavac((XTypeElement)typeElement).getKind()) {
            case CLASS: {
                break;
            }
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: {
                return false;
            }
            default: {
                throw new AssertionError((Object)("TypeElement cannot have kind: " + (Object)((Object)XConverters.toJavac((XTypeElement)typeElement).getKind())));
            }
        }
        if (typeElement.isAbstract()) {
            return false;
        }
        if (ComponentRequirement.requiresEnclosingInstance(typeElement)) {
            return false;
        }
        for (XElement enclosed : typeElement.getEnclosedElements()) {
            if (!XElementKt.isConstructor((XElement)enclosed) || !XElements.asConstructor((XElement)enclosed).getParameters().isEmpty() || XElements.asConstructor((XElement)enclosed).isPrivate()) continue;
            return true;
        }
        return false;
    }

    private static boolean requiresEnclosingInstance(XTypeElement typeElement) {
        return XTypeElements.isNested((XTypeElement)typeElement) && !typeElement.isStatic();
    }

    public static enum NullPolicy {
        NEW,
        THROW,
        ALLOW;

    }

    public static enum Kind {
        DEPENDENCY,
        MODULE,
        BOUND_INSTANCE;


        public boolean isBoundInstance() {
            return this.equals((Object)BOUND_INSTANCE);
        }

        public boolean isModule() {
            return this.equals((Object)MODULE);
        }
    }
}

