/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.writing.FrameworkInstanceBindingRepresentation;
import dagger.internal.codegen.writing.FrameworkInstanceSupplier;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.internal.codegen.writing.StaticMemberSelects;

final class StaticFactoryInstanceSupplier
implements FrameworkInstanceSupplier {
    private final FrameworkInstanceSupplier frameworkInstanceSupplier = () -> this.staticFactoryCreation(binding);

    @AssistedInject
    StaticFactoryInstanceSupplier(@Assisted ProvisionBinding binding, FrameworkInstanceBindingRepresentation.Factory frameworkInstanceBindingRepresentationFactory) {
    }

    @Override
    public MemberSelect memberSelect() {
        return this.frameworkInstanceSupplier.memberSelect();
    }

    private MemberSelect staticFactoryCreation(ProvisionBinding binding) {
        switch (binding.kind()) {
            case MULTIBOUND_MAP: {
                return StaticMemberSelects.emptyMapFactory(binding);
            }
            case MULTIBOUND_SET: {
                return StaticMemberSelects.emptySetFactory(binding);
            }
            case PROVISION: 
            case INJECTION: {
                return StaticMemberSelects.factoryCreateNoArgumentMethod(binding);
            }
        }
        throw new AssertionError((Object)String.format("Invalid binding kind: %s", binding.kind()));
    }

    static boolean usesStaticFactoryCreation(ProvisionBinding binding, boolean isFastInit) {
        if (!binding.dependencies().isEmpty() || binding.scope().isPresent()) {
            return false;
        }
        switch (binding.kind()) {
            case MULTIBOUND_MAP: 
            case MULTIBOUND_SET: {
                return true;
            }
            case PROVISION: {
                return !isFastInit && !binding.requiresModuleInstance();
            }
            case INJECTION: {
                return !isFastInit;
            }
        }
        return false;
    }

    @AssistedFactory
    static interface Factory {
        public StaticFactoryInstanceSupplier create(ProvisionBinding var1);
    }
}

