/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.BindingRepresentation;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.DelegateRequestRepresentation;
import dagger.internal.codegen.writing.DirectInstanceBindingRepresentation;
import dagger.internal.codegen.writing.FrameworkInstanceBindingRepresentation;
import dagger.internal.codegen.writing.FrameworkInstanceSupplier;
import dagger.internal.codegen.writing.ProviderInstanceSupplier;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.writing.StaticFactoryInstanceSupplier;
import dagger.internal.codegen.writing.SwitchingProviderInstanceSupplier;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.model.BindingKind;
import dagger.spi.model.RequestKind;

final class ProvisionBindingRepresentation
implements BindingRepresentation {
    private final BindingGraph graph;
    private final boolean isFastInit;
    private final ProvisionBinding binding;
    private final DirectInstanceBindingRepresentation directInstanceBindingRepresentation;
    private final FrameworkInstanceBindingRepresentation frameworkInstanceBindingRepresentation;

    @AssistedInject
    ProvisionBindingRepresentation(@Assisted ProvisionBinding binding, BindingGraph graph, ComponentImplementation componentImplementation, DirectInstanceBindingRepresentation.Factory directInstanceBindingRepresentationFactory, FrameworkInstanceBindingRepresentation.Factory frameworkInstanceBindingRepresentationFactory, SwitchingProviderInstanceSupplier.Factory switchingProviderInstanceSupplierFactory, ProviderInstanceSupplier.Factory providerInstanceSupplierFactory, StaticFactoryInstanceSupplier.Factory staticFactoryInstanceSupplierFactory, CompilerOptions compilerOptions, DaggerTypes types) {
        this.binding = binding;
        this.graph = graph;
        XTypeElement rootComponent = componentImplementation.rootComponentImplementation().componentDescriptor().typeElement();
        this.isFastInit = compilerOptions.fastInit(rootComponent);
        this.directInstanceBindingRepresentation = directInstanceBindingRepresentationFactory.create(binding);
        FrameworkInstanceSupplier frameworkInstanceSupplier = null;
        frameworkInstanceSupplier = this.usesSwitchingProvider() ? switchingProviderInstanceSupplierFactory.create(binding, this.directInstanceBindingRepresentation) : (StaticFactoryInstanceSupplier.usesStaticFactoryCreation(binding, this.isFastInit) ? staticFactoryInstanceSupplierFactory.create(binding) : providerInstanceSupplierFactory.create(binding));
        this.frameworkInstanceBindingRepresentation = frameworkInstanceBindingRepresentationFactory.create(binding, frameworkInstanceSupplier);
    }

    @Override
    public RequestRepresentation getRequestRepresentation(BindingRequest request) {
        return ProvisionBindingRepresentation.usesDirectInstanceExpression(request.requestKind(), this.binding, this.graph, this.isFastInit) ? this.directInstanceBindingRepresentation.getRequestRepresentation(request) : this.frameworkInstanceBindingRepresentation.getRequestRepresentation(request);
    }

    static boolean usesDirectInstanceExpression(RequestKind requestKind, ProvisionBinding binding, BindingGraph graph, boolean isFastInit) {
        if (requestKind != RequestKind.INSTANCE && requestKind != RequestKind.FUTURE) {
            return false;
        }
        switch (binding.kind()) {
            case MEMBERS_INJECTOR: {
                return false;
            }
            case ASSISTED_INJECTION: 
            case ASSISTED_FACTORY: {
                return isFastInit;
            }
        }
        return !ProvisionBindingRepresentation.needsCaching(binding, graph);
    }

    private boolean usesSwitchingProvider() {
        if (!this.isFastInit) {
            return false;
        }
        switch (this.binding.kind()) {
            case MEMBERS_INJECTOR: 
            case BOUND_INSTANCE: 
            case COMPONENT: 
            case COMPONENT_DEPENDENCY: 
            case DELEGATE: {
                return false;
            }
            case MULTIBOUND_SET: 
            case MULTIBOUND_MAP: 
            case OPTIONAL: {
                return !this.binding.dependencies().isEmpty();
            }
            case ASSISTED_INJECTION: 
            case ASSISTED_FACTORY: 
            case INJECTION: 
            case PROVISION: 
            case COMPONENT_PROVISION: 
            case SUBCOMPONENT_CREATOR: 
            case PRODUCTION: 
            case COMPONENT_PRODUCTION: 
            case MEMBERS_INJECTION: {
                return true;
            }
        }
        throw new AssertionError((Object)String.format("No such binding kind: %s", this.binding.kind()));
    }

    static boolean requiresMethodEncapsulation(ProvisionBinding binding) {
        switch (binding.kind()) {
            case ASSISTED_INJECTION: 
            case ASSISTED_FACTORY: 
            case BOUND_INSTANCE: 
            case COMPONENT: 
            case COMPONENT_DEPENDENCY: 
            case MULTIBOUND_SET: 
            case MULTIBOUND_MAP: 
            case INJECTION: 
            case PROVISION: 
            case COMPONENT_PROVISION: 
            case SUBCOMPONENT_CREATOR: {
                return !binding.dependencies().isEmpty();
            }
            case MEMBERS_INJECTOR: 
            case DELEGATE: 
            case OPTIONAL: 
            case PRODUCTION: 
            case COMPONENT_PRODUCTION: 
            case MEMBERS_INJECTION: {
                return false;
            }
        }
        throw new AssertionError((Object)String.format("No such binding kind: %s", binding.kind()));
    }

    static boolean needsCaching(ProvisionBinding binding, BindingGraph graph) {
        if (!binding.scope().isPresent()) {
            return false;
        }
        if (binding.kind().equals((Object)BindingKind.DELEGATE)) {
            return DelegateRequestRepresentation.isBindsScopeStrongerThanDependencyScope(binding, graph);
        }
        return true;
    }

    @AssistedFactory
    static interface Factory {
        public ProvisionBindingRepresentation create(ProvisionBinding var1);
    }
}

