/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.writing.AssistedPrivateMethodRequestRepresentation;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentMethodRequestRepresentation;
import dagger.internal.codegen.writing.ImmediateFutureRequestRepresentation;
import dagger.internal.codegen.writing.MethodRequestRepresentation;
import dagger.internal.codegen.writing.PrivateMethodRequestRepresentation;
import dagger.internal.codegen.writing.ProvisionBindingRepresentation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.writing.UnscopedDirectInstanceRequestRepresentationFactory;
import dagger.spi.model.BindingKind;
import dagger.spi.model.RequestKind;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

final class DirectInstanceBindingRepresentation {
    private final ProvisionBinding binding;
    private final BindingGraph graph;
    private final ComponentImplementation componentImplementation;
    private final ComponentMethodRequestRepresentation.Factory componentMethodRequestRepresentationFactory;
    private final ImmediateFutureRequestRepresentation.Factory immediateFutureRequestRepresentationFactory;
    private final PrivateMethodRequestRepresentation.Factory privateMethodRequestRepresentationFactory;
    private final AssistedPrivateMethodRequestRepresentation.Factory assistedPrivateMethodRequestRepresentationFactory;
    private final UnscopedDirectInstanceRequestRepresentationFactory unscopedDirectInstanceRequestRepresentationFactory;
    private final Map<BindingRequest, RequestRepresentation> requestRepresentations = new HashMap<BindingRequest, RequestRepresentation>();

    @AssistedInject
    DirectInstanceBindingRepresentation(@Assisted ProvisionBinding binding, BindingGraph graph, ComponentImplementation componentImplementation, ComponentMethodRequestRepresentation.Factory componentMethodRequestRepresentationFactory, ImmediateFutureRequestRepresentation.Factory immediateFutureRequestRepresentationFactory, PrivateMethodRequestRepresentation.Factory privateMethodRequestRepresentationFactory, AssistedPrivateMethodRequestRepresentation.Factory assistedPrivateMethodRequestRepresentationFactory, UnscopedDirectInstanceRequestRepresentationFactory unscopedDirectInstanceRequestRepresentationFactory) {
        this.binding = binding;
        this.graph = graph;
        this.componentImplementation = componentImplementation;
        this.componentMethodRequestRepresentationFactory = componentMethodRequestRepresentationFactory;
        this.immediateFutureRequestRepresentationFactory = immediateFutureRequestRepresentationFactory;
        this.privateMethodRequestRepresentationFactory = privateMethodRequestRepresentationFactory;
        this.unscopedDirectInstanceRequestRepresentationFactory = unscopedDirectInstanceRequestRepresentationFactory;
        this.assistedPrivateMethodRequestRepresentationFactory = assistedPrivateMethodRequestRepresentationFactory;
    }

    public RequestRepresentation getRequestRepresentation(BindingRequest request) {
        return Util.reentrantComputeIfAbsent(this.requestRepresentations, request, this::getRequestRepresentationUncached);
    }

    private RequestRepresentation getRequestRepresentationUncached(BindingRequest request) {
        switch (request.requestKind()) {
            case INSTANCE: {
                return this.instanceRequestRepresentation();
            }
            case FUTURE: {
                return this.immediateFutureRequestRepresentationFactory.create(this.getRequestRepresentation(BindingRequest.bindingRequest(this.binding.key(), RequestKind.INSTANCE)), this.binding.key().type().java());
            }
        }
        throw new AssertionError((Object)String.format("Invalid binding request kind: %s", request.requestKind()));
    }

    private RequestRepresentation instanceRequestRepresentation() {
        RequestRepresentation directInstanceExpression = this.unscopedDirectInstanceRequestRepresentationFactory.create(this.binding);
        if (this.binding.kind() == BindingKind.ASSISTED_INJECTION) {
            BindingRequest request = BindingRequest.bindingRequest(this.binding.key(), RequestKind.INSTANCE);
            return this.assistedPrivateMethodRequestRepresentationFactory.create(request, this.binding, directInstanceExpression);
        }
        return ProvisionBindingRepresentation.requiresMethodEncapsulation(this.binding) ? this.wrapInMethod(RequestKind.INSTANCE, directInstanceExpression) : directInstanceExpression;
    }

    RequestRepresentation wrapInMethod(RequestKind requestKind, RequestRepresentation bindingExpression) {
        if (bindingExpression instanceof MethodRequestRepresentation) {
            return bindingExpression;
        }
        BindingRequest request = BindingRequest.bindingRequest(this.binding.key(), requestKind);
        Optional<ComponentDescriptor.ComponentMethodDescriptor> matchingComponentMethod = this.graph.componentDescriptor().firstMatchingComponentMethod(request);
        ComponentImplementation.ShardImplementation shardImplementation = this.componentImplementation.shardImplementation(this.binding);
        if (matchingComponentMethod.isPresent() && shardImplementation.isComponentShard()) {
            ComponentDescriptor.ComponentMethodDescriptor componentMethod = matchingComponentMethod.get();
            return this.componentMethodRequestRepresentationFactory.create(bindingExpression, componentMethod);
        }
        return this.privateMethodRequestRepresentationFactory.create(request, this.binding, bindingExpression);
    }

    @AssistedFactory
    static interface Factory {
        public DirectInstanceBindingRepresentation create(ProvisionBinding var1);
    }
}

