/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.FrameworkTypes;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.OptionalType;
import dagger.internal.codegen.base.ProducerAnnotations;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.DelegateDeclaration;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.extension.Optionals;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.shaded.androidx.room.compiler.processing.XType;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.DaggerType;
import dagger.spi.model.Key;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;

public final class KeyFactory {
    private final XProcessingEnv processingEnv;
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    KeyFactory(XProcessingEnv processingEnv, DaggerTypes types, DaggerElements elements, InjectionAnnotations injectionAnnotations) {
        this.processingEnv = processingEnv;
        this.types = types;
        this.elements = elements;
        this.injectionAnnotations = injectionAnnotations;
    }

    private TypeMirror boxPrimitives(TypeMirror type2) {
        return type2.getKind().isPrimitive() ? this.types.boxedClass((PrimitiveType)type2).asType() : type2;
    }

    private DeclaredType setOf(TypeMirror elementType) {
        return this.types.getDeclaredType(this.elements.getTypeElement(TypeNames.SET), this.boxPrimitives(elementType));
    }

    private DeclaredType mapOf(TypeMirror keyType, TypeMirror valueType) {
        return this.types.getDeclaredType(this.elements.getTypeElement(TypeNames.MAP), this.boxPrimitives(keyType), this.boxPrimitives(valueType));
    }

    private TypeMirror mapOfFrameworkType(TypeMirror keyType, ClassName frameworkClassName, TypeMirror valueType) {
        return this.mapOf(keyType, this.types.getDeclaredType(this.elements.getTypeElement(frameworkClassName), this.boxPrimitives(valueType)));
    }

    Key forComponentMethod(ExecutableElement componentMethod) {
        Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
        return this.forMethod(componentMethod, componentMethod.getReturnType());
    }

    Key forProductionComponentMethod(ExecutableElement componentMethod) {
        Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
        TypeMirror returnType2 = componentMethod.getReturnType();
        TypeMirror keyType = DaggerTypes.isFutureType(returnType2) ? (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(returnType2).getTypeArguments()) : returnType2;
        return this.forMethod(componentMethod, keyType);
    }

    Key forSubcomponentCreatorMethod(ExecutableElement subcomponentCreatorMethod, DeclaredType declaredContainer) {
        Preconditions.checkArgument((boolean)subcomponentCreatorMethod.getKind().equals((Object)ElementKind.METHOD));
        ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(declaredContainer, subcomponentCreatorMethod));
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)resolvedMethod.getReturnType())).build();
    }

    public Key forSubcomponentCreator(XType creatorType) {
        return this.forSubcomponentCreator(XConverters.toJavac(creatorType));
    }

    public Key forSubcomponentCreator(TypeMirror creatorType) {
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)creatorType)).build();
    }

    public Key forProvidesMethod(ExecutableElement method, TypeElement contributingModule) {
        return this.forBindingMethod(method, contributingModule, Optional.of(TypeNames.PROVIDER));
    }

    public Key forProducesMethod(ExecutableElement method, TypeElement contributingModule) {
        return this.forBindingMethod(method, contributingModule, Optional.of(TypeNames.PRODUCER));
    }

    Key forBindsMethod(ExecutableElement method, TypeElement contributingModule) {
        Preconditions.checkArgument((boolean)DaggerElements.isAnnotationPresent((Element)method, TypeNames.BINDS));
        return this.forBindingMethod(method, contributingModule, Optional.empty());
    }

    Key forBindsOptionalOfMethod(XMethodElement method, XTypeElement contributingModule) {
        Preconditions.checkArgument((boolean)method.hasAnnotation(TypeNames.BINDS_OPTIONAL_OF));
        return this.forBindingMethod(method, contributingModule, Optional.empty());
    }

    private Key forBindingMethod(XMethodElement method, XTypeElement contributingModule, Optional<ClassName> frameworkClassName) {
        return this.forBindingMethod(XConverters.toJavac(method), XConverters.toJavac(contributingModule), frameworkClassName);
    }

    private Key forBindingMethod(ExecutableElement method, TypeElement contributingModule, Optional<ClassName> frameworkClassName) {
        Preconditions.checkArgument((boolean)method.getKind().equals((Object)ElementKind.METHOD));
        ExecutableType methodType = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(contributingModule.asType()), method));
        ContributionType contributionType = ContributionType.fromBindingElement(method);
        TypeMirror returnType2 = methodType.getReturnType();
        if (frameworkClassName.isPresent() && frameworkClassName.get().equals((Object)TypeNames.PRODUCER) && MoreTypes.isType(returnType2)) {
            SetType setType;
            if (DaggerTypes.isFutureType(methodType.getReturnType())) {
                returnType2 = (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(returnType2).getTypeArguments());
            } else if (contributionType.equals((Object)ContributionType.SET_VALUES) && SetType.isSet(returnType2) && DaggerTypes.isFutureType((setType = SetType.from(returnType2)).elementType())) {
                returnType2 = this.types.getDeclaredType(this.elements.getTypeElement(TypeNames.SET), DaggerTypes.unwrapType(setType.elementType()));
            }
        }
        TypeMirror keyType = this.bindingMethodKeyType(returnType2, method, contributionType, frameworkClassName);
        Key key = this.forMethod(method, keyType);
        return contributionType.equals((Object)ContributionType.UNIQUE) ? key : key.toBuilder().multibindingContributionIdentifier(new Key.MultibindingContributionIdentifier(method, contributingModule)).build();
    }

    Key forMultibindsMethod(XMethodElement method, XMethodType methodType) {
        XType returnType2 = method.getReturnType();
        TypeMirror keyType = MapType.isMap(returnType2) ? this.mapOfFrameworkType(MapType.from(returnType2).keyType(), TypeNames.PROVIDER, MapType.from(returnType2).valueType()) : XConverters.toJavac(returnType2);
        return this.forMethod(XConverters.toJavac(method), keyType);
    }

    private TypeMirror bindingMethodKeyType(TypeMirror returnType2, ExecutableElement method, ContributionType contributionType, Optional<ClassName> frameworkClassName) {
        switch (contributionType) {
            case UNIQUE: {
                return returnType2;
            }
            case SET: {
                return this.setOf(returnType2);
            }
            case MAP: {
                TypeMirror mapKeyType = MapKeys.mapKeyType(XConverters.toXProcessing(MapKeys.getMapKey(method).get(), this.processingEnv));
                return frameworkClassName.isPresent() ? this.mapOfFrameworkType(mapKeyType, frameworkClassName.get(), returnType2) : this.mapOf(mapKeyType, returnType2);
            }
            case SET_VALUES: {
                Preconditions.checkArgument((boolean)SetType.isSet(returnType2));
                return returnType2;
            }
        }
        throw new AssertionError();
    }

    Key forDelegateBinding(DelegateDeclaration delegateDeclaration, ClassName frameworkType) {
        return delegateDeclaration.contributionType().equals((Object)ContributionType.MAP) ? this.wrapMapValue(delegateDeclaration.key(), frameworkType) : delegateDeclaration.key();
    }

    private Key forMethod(ExecutableElement method, TypeMirror keyType) {
        return this.forQualifiedType(this.injectionAnnotations.getQualifier(method), keyType);
    }

    public Key forInjectConstructorWithResolvedType(TypeMirror type2) {
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)type2)).build();
    }

    Key forType(TypeMirror type2) {
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)type2)).build();
    }

    public Key forMembersInjectedType(TypeMirror type2) {
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)type2)).build();
    }

    Key forQualifiedType(Optional<AnnotationMirror> qualifier, TypeMirror type2) {
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)this.boxPrimitives(type2))).qualifier(qualifier.map(DaggerAnnotation::fromJava)).build();
    }

    public Key forProductionExecutor() {
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)this.elements.getTypeElement(TypeNames.EXECUTOR).asType())).qualifier(DaggerAnnotation.fromJava((AnnotationMirror)XConverters.toJavac(ProducerAnnotations.productionQualifier(this.processingEnv)))).build();
    }

    public Key forProductionImplementationExecutor() {
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)this.elements.getTypeElement(TypeNames.EXECUTOR).asType())).qualifier(DaggerAnnotation.fromJava((AnnotationMirror)XConverters.toJavac(ProducerAnnotations.productionImplementationQualifier(this.processingEnv)))).build();
    }

    public Key forProductionComponentMonitor() {
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)this.elements.getTypeElement(TypeNames.PRODUCTION_COMPONENT_MONITOR).asType())).build();
    }

    ImmutableSet<Key> implicitFrameworkMapKeys(Key requestKey) {
        return (ImmutableSet)Stream.of(this.implicitMapProviderKeyFrom(requestKey), this.implicitMapProducerKeyFrom(requestKey)).filter(Optional::isPresent).map(Optional::get).collect(DaggerStreams.toImmutableSet());
    }

    Optional<Key> implicitMapProviderKeyFrom(Key possibleMapKey) {
        return Optionals.firstPresent(this.rewrapMapKey(possibleMapKey, TypeNames.PRODUCED, TypeNames.PROVIDER), this.wrapMapKey(possibleMapKey, TypeNames.PROVIDER), (Optional[])new Optional[0]);
    }

    Optional<Key> implicitMapProducerKeyFrom(Key possibleMapKey) {
        return Optionals.firstPresent(this.rewrapMapKey(possibleMapKey, TypeNames.PRODUCED, TypeNames.PRODUCER), this.wrapMapKey(possibleMapKey, TypeNames.PRODUCER), (Optional[])new Optional[0]);
    }

    public Key unwrapMapValueType(Key key) {
        MapType mapType;
        if (MapType.isMap(key) && !(mapType = MapType.from(key)).isRawType()) {
            for (ClassName frameworkClass : Arrays.asList(TypeNames.PROVIDER, TypeNames.PRODUCER, TypeNames.PRODUCED)) {
                if (!mapType.valuesAreTypeOf(frameworkClass)) continue;
                return key.toBuilder().type(DaggerType.fromJava((TypeMirror)this.mapOf(mapType.keyType(), mapType.unwrappedValueType(frameworkClass)))).build();
            }
        }
        return key;
    }

    private Key wrapMapValue(Key key, ClassName newWrappingClassName) {
        Preconditions.checkArgument((boolean)FrameworkTypes.isFrameworkType(this.elements.getTypeElement(newWrappingClassName).asType()));
        return this.wrapMapKey(key, newWrappingClassName).get();
    }

    public Optional<Key> rewrapMapKey(Key possibleMapKey, ClassName currentWrappingClassName, ClassName newWrappingClassName) {
        MapType mapType;
        Preconditions.checkArgument((!currentWrappingClassName.equals((Object)newWrappingClassName) ? 1 : 0) != 0);
        if (MapType.isMap(possibleMapKey) && !(mapType = MapType.from(possibleMapKey)).isRawType() && mapType.valuesAreTypeOf(currentWrappingClassName)) {
            TypeElement wrappingElement = this.elements.getTypeElement(newWrappingClassName);
            if (wrappingElement == null) {
                return Optional.empty();
            }
            DeclaredType wrappedValueType = this.types.getDeclaredType(wrappingElement, mapType.unwrappedValueType(currentWrappingClassName));
            return Optional.of(possibleMapKey.toBuilder().type(DaggerType.fromJava((TypeMirror)this.mapOf(mapType.keyType(), wrappedValueType))).build());
        }
        return Optional.empty();
    }

    private Optional<Key> wrapMapKey(Key possibleMapKey, ClassName wrappingClassName) {
        MapType mapType;
        if (MapType.isMap(possibleMapKey) && !(mapType = MapType.from(possibleMapKey)).isRawType() && !mapType.valuesAreTypeOf(wrappingClassName)) {
            TypeElement wrappingElement = this.elements.getTypeElement(wrappingClassName);
            if (wrappingElement == null) {
                return Optional.empty();
            }
            DeclaredType wrappedValueType = this.types.getDeclaredType(wrappingElement, mapType.valueType());
            return Optional.of(possibleMapKey.toBuilder().type(DaggerType.fromJava((TypeMirror)this.mapOf(mapType.keyType(), wrappedValueType))).build());
        }
        return Optional.empty();
    }

    Optional<Key> unwrapSetKey(Key key, ClassName wrappingClassName) {
        SetType setType;
        if (SetType.isSet(key) && !(setType = SetType.from(key)).isRawType() && setType.elementsAreTypeOf(wrappingClassName)) {
            return Optional.of(key.toBuilder().type(DaggerType.fromJava((TypeMirror)this.setOf(setType.unwrappedElementType(wrappingClassName)))).build());
        }
        return Optional.empty();
    }

    Optional<Key> unwrapOptional(Key key) {
        if (!OptionalType.isOptional(key)) {
            return Optional.empty();
        }
        TypeMirror optionalValueType = OptionalType.from(key).valueType();
        return Optional.of(key.toBuilder().type(DaggerType.fromJava((TypeMirror)RequestKinds.extractKeyType(optionalValueType))).build());
    }
}

