/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.base.Scopes;
import dagger.internal.codegen.binding.ComponentCreatorAnnotation;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ConfigurationAnnotations;
import dagger.internal.codegen.binding.DependencyRequestFactory;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.ModuleDescriptor;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.shaded.androidx.room.compiler.processing.XType;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.shaded.androidx.room.compiler.processing.XTypeKt;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.Scope;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.util.ElementFilter;

public final class ComponentDescriptorFactory {
    private final XProcessingEnv processingEnv;
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final DependencyRequestFactory dependencyRequestFactory;
    private final ModuleDescriptor.Factory moduleDescriptorFactory;
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    ComponentDescriptorFactory(XProcessingEnv processingEnv, DaggerElements elements, DaggerTypes types, DependencyRequestFactory dependencyRequestFactory, ModuleDescriptor.Factory moduleDescriptorFactory, InjectionAnnotations injectionAnnotations) {
        this.processingEnv = processingEnv;
        this.elements = elements;
        this.types = types;
        this.dependencyRequestFactory = dependencyRequestFactory;
        this.moduleDescriptorFactory = moduleDescriptorFactory;
        this.injectionAnnotations = injectionAnnotations;
    }

    public ComponentDescriptor rootComponentDescriptor(XTypeElement typeElement2) {
        Optional<ComponentAnnotation> annotation = ComponentAnnotation.rootComponentAnnotation(typeElement2);
        Preconditions.checkArgument((boolean)annotation.isPresent(), (String)"%s must have a component annotation", (Object)typeElement2);
        return this.create(typeElement2, annotation.get());
    }

    public ComponentDescriptor subcomponentDescriptor(XTypeElement typeElement2) {
        Optional<ComponentAnnotation> annotation = ComponentAnnotation.subcomponentAnnotation(typeElement2);
        Preconditions.checkArgument((boolean)annotation.isPresent(), (String)"%s must have a subcomponent annotation", (Object)typeElement2);
        return this.create(typeElement2, annotation.get());
    }

    public ComponentDescriptor moduleComponentDescriptor(XTypeElement typeElement2) {
        Optional<ModuleAnnotation> annotation = ModuleAnnotation.moduleAnnotation(typeElement2);
        Preconditions.checkArgument((boolean)annotation.isPresent(), (String)"%s must have a module annotation", (Object)typeElement2);
        return this.create(typeElement2, ComponentAnnotation.fromModuleAnnotation(annotation.get()));
    }

    private ComponentDescriptor create(XTypeElement typeElement2, ComponentAnnotation componentAnnotation) {
        ImmutableSet<XTypeElement> enclosedCreators;
        ImmutableSet componentDependencies = (ImmutableSet)componentAnnotation.dependencyTypes().stream().map(ComponentRequirement::forDependency).collect(DaggerStreams.toImmutableSet());
        ImmutableMap.Builder dependenciesByDependencyMethod = ImmutableMap.builder();
        for (ComponentRequirement componentDependency : componentDependencies) {
            for (ExecutableElement dependencyMethod : ElementFilter.methodsIn(this.elements.getAllMembers(componentDependency.typeElement()))) {
                if (!ComponentDescriptor.isComponentContributionMethod(dependencyMethod)) continue;
                dependenciesByDependencyMethod.put((Object)((XMethodElement)XConverters.toXProcessing(dependencyMethod, this.processingEnv)), (Object)componentDependency);
            }
        }
        ImmutableSet modules = componentAnnotation.isRealComponent() ? (ImmutableSet)componentAnnotation.modules().stream().map(module -> XConverters.toXProcessing(module, this.processingEnv)).collect(DaggerStreams.toImmutableSet()) : ImmutableSet.of((Object)typeElement2);
        ImmutableSet<ModuleDescriptor> transitiveModules = this.moduleDescriptorFactory.transitiveModules((Collection<XTypeElement>)modules);
        ImmutableSet subcomponentsFromModules = (ImmutableSet)transitiveModules.stream().flatMap(transitiveModule -> transitiveModule.subcomponentDeclarations().stream()).map(SubcomponentDeclaration::subcomponentType).map(this::subcomponentDescriptor).collect(DaggerStreams.toImmutableSet());
        ImmutableSet.Builder componentMethodsBuilder = ImmutableSet.builder();
        ImmutableBiMap.Builder subcomponentsByFactoryMethod = ImmutableBiMap.builder();
        ImmutableBiMap.Builder subcomponentsByBuilderMethod = ImmutableBiMap.builder();
        if (componentAnnotation.isRealComponent()) {
            for (XMethodElement componentMethod : XTypeElements.getAllUnimplementedMethods(typeElement2)) {
                ComponentDescriptor.ComponentMethodDescriptor componentMethodDescriptor = this.getDescriptorForComponentMethod(componentAnnotation, typeElement2, componentMethod);
                componentMethodsBuilder.add((Object)componentMethodDescriptor);
                componentMethodDescriptor.subcomponent().ifPresent(subcomponent -> {
                    if (componentMethodDescriptor.dependencyRequest().isPresent()) {
                        subcomponentsByBuilderMethod.put((Object)componentMethodDescriptor, subcomponent);
                    } else {
                        subcomponentsByFactoryMethod.put((Object)componentMethodDescriptor, subcomponent);
                    }
                });
            }
        }
        Optional<ComponentCreatorDescriptor> creatorDescriptor = (enclosedCreators = ConfigurationAnnotations.enclosedAnnotatedTypes(typeElement2, ComponentCreatorAnnotation.creatorAnnotationsFor(componentAnnotation))).isEmpty() ? Optional.empty() : Optional.of(ComponentCreatorDescriptor.create((XTypeElement)Iterables.getOnlyElement(enclosedCreators), this.types, this.dependencyRequestFactory));
        ImmutableSet scopes = Scopes.scopesOf(typeElement2);
        if (componentAnnotation.isProduction()) {
            scopes = ImmutableSet.builder().addAll(scopes).add((Object)Scopes.productionScope(this.processingEnv)).build();
        }
        return ComponentDescriptor.create(this.processingEnv, componentAnnotation, typeElement2, (ImmutableSet<ComponentRequirement>)componentDependencies, transitiveModules, (ImmutableMap<XMethodElement, ComponentRequirement>)dependenciesByDependencyMethod.build(), (ImmutableSet<Scope>)scopes, (ImmutableSet<ComponentDescriptor>)subcomponentsFromModules, (ImmutableBiMap<ComponentDescriptor.ComponentMethodDescriptor, ComponentDescriptor>)subcomponentsByFactoryMethod.build(), (ImmutableBiMap<ComponentDescriptor.ComponentMethodDescriptor, ComponentDescriptor>)subcomponentsByBuilderMethod.build(), (ImmutableSet<ComponentDescriptor.ComponentMethodDescriptor>)componentMethodsBuilder.build(), creatorDescriptor);
    }

    private ComponentDescriptor.ComponentMethodDescriptor getDescriptorForComponentMethod(ComponentAnnotation componentAnnotation, XTypeElement componentElement, XMethodElement componentMethod) {
        ComponentDescriptor.ComponentMethodDescriptor.Builder descriptor2 = ComponentDescriptor.ComponentMethodDescriptor.builder(componentMethod);
        XMethodType resolvedComponentMethod = componentMethod.asMemberOf(componentElement.getType());
        XType returnType2 = resolvedComponentMethod.getReturnType();
        if (XTypes.isDeclared(returnType2) && !this.injectionAnnotations.getQualifier(componentMethod).isPresent()) {
            XTypeElement returnTypeElement = returnType2.getTypeElement();
            if (ComponentAnnotation.subcomponentAnnotation(returnTypeElement).isPresent()) {
                return descriptor2.subcomponent(this.subcomponentDescriptor(returnTypeElement)).build();
            }
            if (ConfigurationAnnotations.isSubcomponentCreator(returnTypeElement)) {
                descriptor2.subcomponent(this.subcomponentDescriptor(returnTypeElement.getEnclosingTypeElement()));
            }
        }
        ExecutableType javaResolvedComponentMethod = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(XConverters.toJavac(componentElement.getType())), XConverters.toJavac(componentMethod)));
        switch (componentMethod.getParameters().size()) {
            case 0: {
                Preconditions.checkArgument((!XTypeKt.isVoid(returnType2) ? 1 : 0) != 0, (String)"component method cannot be void: %s", (Object)componentMethod);
                descriptor2.dependencyRequest(componentAnnotation.isProduction() ? this.dependencyRequestFactory.forComponentProductionMethod(componentMethod, javaResolvedComponentMethod) : this.dependencyRequestFactory.forComponentProvisionMethod(componentMethod, javaResolvedComponentMethod));
                break;
            }
            case 1: {
                Preconditions.checkArgument((XTypeKt.isVoid(returnType2) || MoreTypes.equivalence().equivalent((Object)XConverters.toJavac(returnType2), (Object)javaResolvedComponentMethod.getParameterTypes().get(0)) ? 1 : 0) != 0, (String)"members injection method must return void or parameter type: %s", (Object)componentMethod);
                descriptor2.dependencyRequest(this.dependencyRequestFactory.forComponentMembersInjectionMethod(componentMethod, javaResolvedComponentMethod));
                break;
            }
            default: {
                throw new IllegalArgumentException("component method has too many parameters: " + componentMethod);
            }
        }
        return descriptor2.build();
    }
}

