/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.Traverser;
import dagger.internal.codegen.base.TarjanSCCs;
import dagger.internal.codegen.binding.AutoValue_BindingGraph;
import dagger.internal.codegen.binding.AutoValue_BindingGraph_TopLevelBindingGraph;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingNode;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentNodeImpl;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ModuleDescriptor;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.ComponentPath;
import dagger.spi.model.DaggerTypeElement;
import dagger.spi.model.Key;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@AutoValue
public abstract class BindingGraph {
    private ImmutableMap<Key, BindingNode> contributionBindings;
    private ImmutableMap<Key, BindingNode> membersInjectionBindings;
    private ImmutableSet<ModuleDescriptor> inheritedModules;
    private ImmutableSet<ModuleDescriptor> ownedModules;
    private ImmutableSet<TypeElement> bindingModules;

    static BindingGraph create(BindingGraph.ComponentNode componentNode, TopLevelBindingGraph topLevelBindingGraph) {
        return BindingGraph.create(Optional.empty(), componentNode, topLevelBindingGraph);
    }

    private static BindingGraph create(Optional<BindingGraph> parent, BindingGraph.ComponentNode componentNode, TopLevelBindingGraph topLevelBindingGraph) {
        ImmutableSet inheritedModules;
        LinkedHashMap contributionBindings = new LinkedHashMap();
        LinkedHashMap membersInjectionBindings = new LinkedHashMap();
        Stream.iterate(componentNode.componentPath(), ComponentPath::parent).limit(componentNode.componentPath().components().size()).flatMap(path -> topLevelBindingGraph.bindingsByComponent().get(path).stream()).forEach(bindingNode -> {
            if (bindingNode.delegate() instanceof ContributionBinding) {
                contributionBindings.putIfAbsent(bindingNode.key(), bindingNode);
            } else if (bindingNode.delegate() instanceof MembersInjectionBinding) {
                membersInjectionBindings.putIfAbsent(bindingNode.key(), bindingNode);
            } else {
                throw new AssertionError((Object)("Unexpected binding node type: " + bindingNode.delegate()));
            }
        });
        AutoValue_BindingGraph bindingGraph = new AutoValue_BindingGraph(componentNode, topLevelBindingGraph);
        ImmutableSet<ModuleDescriptor> modules = ((ComponentNodeImpl)componentNode).componentDescriptor().modules();
        bindingGraph.inheritedModules = inheritedModules = parent.isPresent() ? Sets.union(parent.get().ownedModules, parent.get().inheritedModules).immutableCopy() : ImmutableSet.of();
        bindingGraph.ownedModules = Sets.difference(modules, (Set)inheritedModules).immutableCopy();
        bindingGraph.contributionBindings = ImmutableMap.copyOf(contributionBindings);
        bindingGraph.membersInjectionBindings = ImmutableMap.copyOf(membersInjectionBindings);
        bindingGraph.bindingModules = (ImmutableSet)contributionBindings.values().stream().map(BindingNode::contributingModule).flatMap(DaggerStreams.presentValues()).map(DaggerTypeElement::java).collect(DaggerStreams.toImmutableSet());
        return bindingGraph;
    }

    BindingGraph() {
    }

    public abstract BindingGraph.ComponentNode componentNode();

    public final ComponentPath componentPath() {
        return this.componentNode().componentPath();
    }

    public abstract TopLevelBindingGraph topLevelBindingGraph();

    public final ComponentDescriptor componentDescriptor() {
        return ((ComponentNodeImpl)this.componentNode()).componentDescriptor();
    }

    public final Optional<Binding> localContributionBinding(Key key) {
        return this.contributionBindings.containsKey((Object)key) ? Optional.of((BindingNode)this.contributionBindings.get((Object)key)).filter(bindingNode -> bindingNode.componentPath().equals((Object)this.componentPath())).map(BindingNode::delegate) : Optional.empty();
    }

    public final Optional<Binding> localMembersInjectionBinding(Key key) {
        return this.membersInjectionBindings.containsKey((Object)key) ? Optional.of((BindingNode)this.membersInjectionBindings.get((Object)key)).filter(bindingNode -> bindingNode.componentPath().equals((Object)this.componentPath())).map(BindingNode::delegate) : Optional.empty();
    }

    public final ContributionBinding contributionBinding(Key key) {
        return (ContributionBinding)((BindingNode)this.contributionBindings.get((Object)key)).delegate();
    }

    public final Optional<MembersInjectionBinding> membersInjectionBinding(Key key) {
        return this.membersInjectionBindings.containsKey((Object)key) ? Optional.of((MembersInjectionBinding)((BindingNode)this.membersInjectionBindings.get((Object)key)).delegate()) : Optional.empty();
    }

    public final TypeElement componentTypeElement() {
        return this.componentPath().currentComponent().java();
    }

    public final ImmutableSet<TypeElement> ownedModuleTypes() {
        return (ImmutableSet)this.ownedModules.stream().map(ModuleDescriptor::moduleElement).map(XConverters::toJavac).collect(DaggerStreams.toImmutableSet());
    }

    public final Optional<ExecutableElement> factoryMethod() {
        return (Optional)this.topLevelBindingGraph().network().inEdges((Object)this.componentNode()).stream().filter(edge -> edge instanceof BindingGraph.ChildFactoryMethodEdge).map(edge -> ((BindingGraph.ChildFactoryMethodEdge)edge).factoryMethod().java()).collect(DaggerCollectors.toOptional());
    }

    public final ImmutableMap<ComponentRequirement, VariableElement> factoryMethodParameters() {
        return (ImmutableMap)this.factoryMethod().get().getParameters().stream().collect(DaggerStreams.toImmutableMap(parameter -> ComponentRequirement.forModule(parameter.asType()), parameter -> parameter));
    }

    public ImmutableSet<ComponentRequirement> componentRequirements() {
        ImmutableSet requiredModules = (ImmutableSet)DaggerStreams.stream((Iterable)Traverser.forTree(BindingGraph::subgraphs).depthFirstPostOrder((Object)this)).flatMap(graph -> graph.bindingModules.stream()).filter(arg_0 -> this.ownedModuleTypes().contains(arg_0)).collect(DaggerStreams.toImmutableSet());
        ImmutableSet.Builder requirements = ImmutableSet.builder();
        this.componentDescriptor().requirements().stream().filter(requirement -> !requirement.kind().isModule() || requiredModules.contains((Object)requirement.typeElement())).forEach(arg_0 -> ((ImmutableSet.Builder)requirements).add(arg_0));
        if (this.factoryMethod().isPresent()) {
            requirements.addAll((Iterable)this.factoryMethodParameters().keySet());
        }
        return requirements.build();
    }

    public ImmutableMap<ComponentPath, ComponentDescriptor> componentDescriptorsByPath() {
        return (ImmutableMap)this.topLevelBindingGraph().componentNodes().stream().map(ComponentNodeImpl.class::cast).collect(DaggerStreams.toImmutableMap(BindingGraph.ComponentNode::componentPath, ComponentNodeImpl::componentDescriptor));
    }

    public ImmutableList<BindingGraph> subgraphs() {
        return (ImmutableList)this.topLevelBindingGraph().subcomponentNodes(this.componentNode()).stream().map(subcomponent -> BindingGraph.create(Optional.of(this), subcomponent, this.topLevelBindingGraph())).collect(DaggerStreams.toImmutableList());
    }

    public ImmutableList<BindingNode> localBindingNodes() {
        return this.topLevelBindingGraph().bindingsByComponent().get((Object)this.componentPath());
    }

    public ImmutableSet<BindingNode> bindingNodes() {
        return ImmutableSet.builder().addAll((Iterable)this.contributionBindings.values()).addAll((Iterable)this.membersInjectionBindings.values()).build();
    }

    @AutoValue
    public static abstract class TopLevelBindingGraph
    extends dagger.spi.model.BindingGraph {
        private ImmutableMap<ComponentPath, BindingGraph.ComponentNode> componentNodes;
        private ImmutableSetMultimap<BindingGraph.ComponentNode, BindingGraph.ComponentNode> subcomponentNodes;

        static TopLevelBindingGraph create(ImmutableNetwork<BindingGraph.Node, BindingGraph.Edge> network, boolean isFullBindingGraph) {
            AutoValue_BindingGraph_TopLevelBindingGraph topLevelBindingGraph = new AutoValue_BindingGraph_TopLevelBindingGraph(network, isFullBindingGraph);
            ImmutableMap componentNodes = (ImmutableMap)topLevelBindingGraph.componentNodes().stream().collect(DaggerStreams.toImmutableMap(BindingGraph.ComponentNode::componentPath, componentNode -> componentNode));
            ImmutableSetMultimap.Builder subcomponentNodesBuilder = ImmutableSetMultimap.builder();
            topLevelBindingGraph.componentNodes().stream().filter(componentNode -> !componentNode.componentPath().atRoot()).forEach(componentNode -> subcomponentNodesBuilder.put((Object)((BindingGraph.ComponentNode)componentNodes.get((Object)componentNode.componentPath().parent())), componentNode));
            topLevelBindingGraph.componentNodes = componentNodes;
            topLevelBindingGraph.subcomponentNodes = subcomponentNodesBuilder.build();
            return topLevelBindingGraph;
        }

        TopLevelBindingGraph() {
        }

        public Optional<BindingGraph.ComponentNode> componentNode(ComponentPath componentPath) {
            return this.componentNodes.containsKey((Object)componentPath) ? Optional.of((BindingGraph.ComponentNode)this.componentNodes.get((Object)componentPath)) : Optional.empty();
        }

        ImmutableSet<BindingGraph.ComponentNode> subcomponentNodes(BindingGraph.ComponentNode componentNode) {
            return this.subcomponentNodes.get((Object)componentNode);
        }

        public ImmutableSetMultimap<Class<? extends BindingGraph.Node>, ? extends BindingGraph.Node> nodesByClass() {
            return super.nodesByClass();
        }

        ImmutableListMultimap<ComponentPath, BindingNode> bindingsByComponent() {
            return Multimaps.index((Iterable)Iterables.transform((Iterable)this.bindings(), BindingNode.class::cast), BindingGraph.Node::componentPath);
        }

        Comparator<BindingGraph.Node> nodeOrder() {
            HashMap nodeOrderMap = Maps.newHashMapWithExpectedSize((int)this.network().nodes().size());
            int i = 0;
            for (BindingGraph.Node node : this.network().nodes()) {
                nodeOrderMap.put(node, i++);
            }
            return (n1, n2) -> ((Integer)nodeOrderMap.get(n1)).compareTo((Integer)nodeOrderMap.get(n2));
        }

        public ImmutableSet<ImmutableSet<BindingGraph.Node>> stronglyConnectedNodes() {
            return TarjanSCCs.compute(ImmutableSet.copyOf((Collection)this.network().nodes()), node -> (Iterable)this.network().successors(node).stream().sorted(this.nodeOrder()).collect(DaggerStreams.toImmutableList()));
        }
    }
}

