/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dagger.internal.codegen.base.DiagnosticFormatting;
import dagger.internal.codegen.base.ElementFormatter;
import dagger.internal.codegen.base.Formatter;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.internal.codegen.binding.MethodSignatureFormatter;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;

public final class BindingDeclarationFormatter
extends Formatter<BindingDeclaration> {
    private static final ImmutableSet<TypeKind> FORMATTABLE_ELEMENT_TYPE_KINDS = Sets.immutableEnumSet((Enum)TypeKind.EXECUTABLE, (Enum[])new TypeKind[]{TypeKind.DECLARED});
    private final MethodSignatureFormatter methodSignatureFormatter;

    @Inject
    BindingDeclarationFormatter(MethodSignatureFormatter methodSignatureFormatter) {
        this.methodSignatureFormatter = methodSignatureFormatter;
    }

    public boolean canFormat(BindingDeclaration bindingDeclaration) {
        if (bindingDeclaration instanceof SubcomponentDeclaration) {
            return true;
        }
        if (bindingDeclaration.bindingElement().isPresent()) {
            Element bindingElement = bindingDeclaration.bindingElement().get();
            return bindingElement.getKind().equals((Object)ElementKind.PARAMETER) || FORMATTABLE_ELEMENT_TYPE_KINDS.contains((Object)bindingElement.asType().getKind());
        }
        return false;
    }

    @Override
    public String format(BindingDeclaration bindingDeclaration) {
        if (bindingDeclaration instanceof SubcomponentDeclaration) {
            return this.formatSubcomponentDeclaration((SubcomponentDeclaration)bindingDeclaration);
        }
        if (bindingDeclaration.bindingElement().isPresent()) {
            Element bindingElement = bindingDeclaration.bindingElement().get();
            if (bindingElement.getKind().equals((Object)ElementKind.PARAMETER)) {
                return ElementFormatter.elementToString(bindingElement);
            }
            switch (bindingElement.asType().getKind()) {
                case EXECUTABLE: {
                    return this.methodSignatureFormatter.format(MoreElements.asExecutable(bindingElement), bindingDeclaration.contributingModule().map(module -> MoreTypes.asDeclared(module.asType())));
                }
                case DECLARED: {
                    return DiagnosticFormatting.stripCommonTypePrefixes(bindingElement.asType().toString());
                }
            }
            throw new IllegalArgumentException("Formatting unsupported for element: " + bindingElement);
        }
        return String.format("Dagger-generated binding for %s", DiagnosticFormatting.stripCommonTypePrefixes(bindingDeclaration.key().toString()));
    }

    private String formatSubcomponentDeclaration(SubcomponentDeclaration subcomponentDeclaration) {
        ImmutableList<TypeElement> moduleSubcomponents = subcomponentDeclaration.moduleAnnotation().subcomponents();
        int index = moduleSubcomponents.indexOf((Object)XConverters.toJavac(subcomponentDeclaration.subcomponentType()));
        StringBuilder annotationValue = new StringBuilder();
        if (moduleSubcomponents.size() != 1) {
            annotationValue.append("{");
        }
        annotationValue.append(BindingDeclarationFormatter.formatArgumentInList(index, moduleSubcomponents.size(), subcomponentDeclaration.subcomponentType().getQualifiedName() + ".class"));
        if (moduleSubcomponents.size() != 1) {
            annotationValue.append("}");
        }
        return String.format("@%s(subcomponents = %s) for %s", subcomponentDeclaration.moduleAnnotation().annotationName(), annotationValue, subcomponentDeclaration.contributingModule().get());
    }
}

