/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.AutoValue_ComponentAnnotation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.base.MoreAnnotationValues;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.shaded.androidx.room.compiler.processing.XElement;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Collection;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@AutoValue
public abstract class ComponentAnnotation {
    private static final ImmutableSet<ClassName> ROOT_COMPONENT_ANNOTATIONS = ImmutableSet.of((Object)TypeNames.COMPONENT, (Object)TypeNames.PRODUCTION_COMPONENT);
    private static final ImmutableSet<ClassName> SUBCOMPONENT_ANNOTATIONS = ImmutableSet.of((Object)TypeNames.SUBCOMPONENT, (Object)TypeNames.PRODUCTION_SUBCOMPONENT);
    private static final ImmutableSet<ClassName> CREATOR_ANNOTATIONS = ImmutableSet.of((Object)TypeNames.COMPONENT_BUILDER, (Object)TypeNames.COMPONENT_FACTORY, (Object)TypeNames.PRODUCTION_COMPONENT_BUILDER, (Object)TypeNames.PRODUCTION_COMPONENT_FACTORY, (Object)TypeNames.SUBCOMPONENT_BUILDER, (Object)TypeNames.SUBCOMPONENT_FACTORY, (Object[])new ClassName[]{TypeNames.PRODUCTION_SUBCOMPONENT_BUILDER, TypeNames.PRODUCTION_SUBCOMPONENT_FACTORY});
    private static final ImmutableSet<ClassName> ALL_COMPONENT_ANNOTATIONS = ImmutableSet.builder().addAll(ROOT_COMPONENT_ANNOTATIONS).addAll(SUBCOMPONENT_ANNOTATIONS).build();
    private static final ImmutableSet<ClassName> ALL_COMPONENT_AND_CREATOR_ANNOTATIONS = ImmutableSet.builder().addAll(ALL_COMPONENT_ANNOTATIONS).addAll(CREATOR_ANNOTATIONS).build();
    private static final ImmutableSet<ClassName> PRODUCTION_ANNOTATIONS = ImmutableSet.of((Object)TypeNames.PRODUCTION_COMPONENT, (Object)TypeNames.PRODUCTION_SUBCOMPONENT, (Object)TypeNames.PRODUCER_MODULE);

    public abstract AnnotationMirror annotation();

    public final String simpleName() {
        return this.annotationClassName().simpleName();
    }

    public final boolean isSubcomponent() {
        return SUBCOMPONENT_ANNOTATIONS.contains((Object)this.annotationClassName());
    }

    public final boolean isProduction() {
        return PRODUCTION_ANNOTATIONS.contains((Object)this.annotationClassName());
    }

    public final boolean isRealComponent() {
        return ALL_COMPONENT_ANNOTATIONS.contains((Object)this.annotationClassName());
    }

    public ImmutableList<AnnotationValue> dependencyValues() {
        return this.isRootComponent() ? this.getAnnotationValues("dependencies") : ImmutableList.of();
    }

    public ImmutableList<TypeMirror> dependencyTypes() {
        return (ImmutableList)this.dependencyValues().stream().map(MoreAnnotationValues::asType).collect(DaggerStreams.toImmutableList());
    }

    public ImmutableList<TypeElement> dependencies() {
        return MoreTypes.asTypeElements(this.dependencyTypes()).asList();
    }

    public ImmutableList<AnnotationValue> moduleValues() {
        return this.getAnnotationValues(this.isRealComponent() ? "modules" : "includes");
    }

    public ImmutableList<TypeMirror> moduleTypes() {
        return (ImmutableList)this.moduleValues().stream().map(MoreAnnotationValues::asType).collect(DaggerStreams.toImmutableList());
    }

    public ImmutableSet<TypeElement> modules() {
        return MoreTypes.asTypeElements(this.moduleTypes());
    }

    private ImmutableList<AnnotationValue> getAnnotationValues(String parameterName) {
        return MoreAnnotationValues.asAnnotationValues(AnnotationMirrors.getAnnotationValue(this.annotation(), parameterName));
    }

    private final boolean isRootComponent() {
        return ROOT_COMPONENT_ANNOTATIONS.contains((Object)this.annotationClassName());
    }

    private ClassName annotationClassName() {
        return ClassName.get((TypeElement)MoreTypes.asTypeElement(this.annotation().getAnnotationType()));
    }

    public static Optional<ComponentAnnotation> rootComponentAnnotation(XTypeElement typeElement2) {
        return ComponentAnnotation.anyComponentAnnotation(typeElement2, ROOT_COMPONENT_ANNOTATIONS);
    }

    public static Optional<ComponentAnnotation> subcomponentAnnotation(XTypeElement typeElement2) {
        return ComponentAnnotation.subcomponentAnnotation(XConverters.toJavac(typeElement2));
    }

    public static Optional<ComponentAnnotation> subcomponentAnnotation(TypeElement typeElement2) {
        return ComponentAnnotation.anyComponentAnnotation(typeElement2, SUBCOMPONENT_ANNOTATIONS);
    }

    public static Optional<ComponentAnnotation> anyComponentAnnotation(XElement element) {
        return ComponentAnnotation.anyComponentAnnotation(XConverters.toJavac(element), ALL_COMPONENT_ANNOTATIONS);
    }

    private static Optional<ComponentAnnotation> anyComponentAnnotation(XElement element, Collection<ClassName> annotations2) {
        return ComponentAnnotation.anyComponentAnnotation(XConverters.toJavac(element), annotations2);
    }

    private static Optional<ComponentAnnotation> anyComponentAnnotation(Element element, Collection<ClassName> annotations2) {
        return DaggerElements.getAnyAnnotation(element, annotations2).map(ComponentAnnotation::componentAnnotation);
    }

    public static boolean isComponentAnnotation(XAnnotation annotation) {
        return ComponentAnnotation.isComponentAnnotation(XConverters.toJavac(annotation));
    }

    public static boolean isComponentAnnotation(AnnotationMirror annotation) {
        ClassName className2 = ClassName.get((TypeElement)MoreTypes.asTypeElement(annotation.getAnnotationType()));
        return ALL_COMPONENT_ANNOTATIONS.contains((Object)className2);
    }

    public static ComponentAnnotation componentAnnotation(XAnnotation annotation) {
        return ComponentAnnotation.componentAnnotation(XConverters.toJavac(annotation));
    }

    public static ComponentAnnotation componentAnnotation(AnnotationMirror annotation) {
        Preconditions.checkState((boolean)ComponentAnnotation.isComponentAnnotation(annotation), (Object)(annotation + " must be a Component, Subcomponent, ProductionComponent, or ProductionSubcomponent annotation"));
        return new AutoValue_ComponentAnnotation(annotation);
    }

    public static ComponentAnnotation fromModuleAnnotation(ModuleAnnotation moduleAnnotation) {
        return new AutoValue_ComponentAnnotation(moduleAnnotation.annotation());
    }

    public static ImmutableSet<ClassName> rootComponentAnnotations() {
        return ROOT_COMPONENT_ANNOTATIONS;
    }

    public static ImmutableSet<ClassName> subcomponentAnnotations() {
        return SUBCOMPONENT_ANNOTATIONS;
    }

    public static ImmutableSet<ClassName> allComponentAnnotations() {
        return ALL_COMPONENT_ANNOTATIONS;
    }

    public static ImmutableSet<ClassName> allComponentAndCreatorAnnotations() {
        return ALL_COMPONENT_AND_CREATOR_ANNOTATIONS;
    }
}

