/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.shaded.androidx.room.compiler.processing.XMessager;
import dagger.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import javax.inject.Inject;

final class AssistedProcessingStep
extends TypeCheckingProcessingStep<XExecutableParameterElement> {
    private final InjectionAnnotations injectionAnnotations;
    private final DaggerElements elements;
    private final XMessager messager;
    private final XProcessingEnv processingEnv;

    @Inject
    AssistedProcessingStep(InjectionAnnotations injectionAnnotations, DaggerElements elements, XMessager messager2, XProcessingEnv processingEnv) {
        this.injectionAnnotations = injectionAnnotations;
        this.elements = elements;
        this.messager = messager2;
        this.processingEnv = processingEnv;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.ASSISTED);
    }

    @Override
    protected void process(XExecutableParameterElement assisted, ImmutableSet<ClassName> annotations2) {
        new AssistedValidator().validate(assisted).printMessagesTo(this.messager);
    }

    private boolean isAssistedInjectConstructor(XExecutableElement executableElement) {
        return XElementKt.isConstructor(executableElement) && executableElement.hasAnnotation(TypeNames.ASSISTED_INJECT);
    }

    private boolean isAssistedFactoryCreateMethod(XExecutableElement executableElement) {
        if (XElementKt.isMethod(executableElement)) {
            XTypeElement enclosingElement2 = DaggerElements.closestEnclosingTypeElement(executableElement, this.processingEnv);
            return AssistedInjectionAnnotations.isAssistedFactoryType(enclosingElement2) && AssistedInjectionAnnotations.assistedFactoryMethod(enclosingElement2, this.elements).equals(XConverters.toJavac(executableElement));
        }
        return false;
    }

    private boolean isKotlinDataClassCopyMethod(XExecutableElement executableElement) {
        return XElementKt.isMethod(executableElement) && XElements.asMethod(executableElement).getName().contentEquals("copy") && DaggerElements.closestEnclosingTypeElement(executableElement.getEnclosingElement(), this.processingEnv).isDataClass();
    }

    private final class AssistedValidator {
        private AssistedValidator() {
        }

        ValidationReport validate(XExecutableParameterElement assisted) {
            ValidationReport.Builder report = ValidationReport.about(assisted);
            XExecutableElement enclosingElement2 = assisted.getEnclosingMethodElement();
            if (!(AssistedProcessingStep.this.isAssistedInjectConstructor(enclosingElement2) || AssistedProcessingStep.this.isAssistedFactoryCreateMethod(enclosingElement2) || AssistedProcessingStep.this.isKotlinDataClassCopyMethod(enclosingElement2))) {
                report.addError("@Assisted parameters can only be used within an @AssistedInject-annotated constructor.", assisted);
            }
            AssistedProcessingStep.this.injectionAnnotations.getQualifiers(assisted, AssistedProcessingStep.this.processingEnv).forEach(qualifier -> report.addError("Qualifiers cannot be used with @Assisted parameters.", assisted, (XAnnotation)qualifier));
            return report.build();
        }
    }
}

