/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.AnnotationSpec;
import dagger.internal.codegen.binding.Binding;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;

final class GwtCompatibility {
    GwtCompatibility() {
    }

    static Optional<AnnotationSpec> gwtIncompatibleAnnotation(Binding binding) {
        Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        for (Element element = XConverters.toJavac((XElement)binding.bindingElement().get()); element != null; element = element.getEnclosingElement()) {
            Optional<AnnotationSpec> gwtIncompatible = element.getAnnotationMirrors().stream().filter(annotation -> GwtCompatibility.isGwtIncompatible(annotation)).map(AnnotationSpec::get).findFirst();
            if (!gwtIncompatible.isPresent()) continue;
            return gwtIncompatible;
        }
        return Optional.empty();
    }

    private static boolean isGwtIncompatible(AnnotationMirror annotation) {
        Name simpleName = annotation.getAnnotationType().asElement().getSimpleName();
        return simpleName.contentEquals("GwtIncompatible");
    }
}

