/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.FrameworkTypes;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.BindingElementValidator;
import dagger.internal.codegen.validation.BindingMethodValidator;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import javax.inject.Inject;

class MultibindsMethodValidator
extends BindingMethodValidator {
    @Inject
    MultibindsMethodValidator(DaggerTypes types, DependencyRequestValidator dependencyRequestValidator, InjectionAnnotations injectionAnnotations) {
        super(types, TypeNames.MULTIBINDS, (Iterable<ClassName>)ImmutableSet.of((Object)TypeNames.MODULE, (Object)TypeNames.PRODUCER_MODULE), dependencyRequestValidator, BindingMethodValidator.Abstractness.MUST_BE_ABSTRACT, BindingMethodValidator.ExceptionSuperclass.NO_EXCEPTIONS, BindingElementValidator.AllowsMultibindings.NO_MULTIBINDINGS, BindingElementValidator.AllowsScoping.NO_SCOPING, injectionAnnotations);
    }

    @Override
    protected BindingElementValidator.ElementValidator elementValidator(XMethodElement method) {
        return new Validator(method);
    }

    private class Validator
    extends BindingMethodValidator.MethodValidator {
        private final XMethodElement method;

        Validator(XMethodElement method) {
            super(MultibindsMethodValidator.this, method);
            this.method = method;
        }

        @Override
        protected void checkParameters() {
            if (!this.method.getParameters().isEmpty()) {
                this.report.addError(MultibindsMethodValidator.this.bindingMethods("cannot have parameters", new Object[0]));
            }
        }

        @Override
        protected void checkType() {
            if (!this.isPlainMap(this.method.getReturnType()) && !this.isPlainSet(this.method.getReturnType())) {
                this.report.addError(MultibindsMethodValidator.this.bindingMethods("must return Map<K, V> or Set<T>", new Object[0]));
            }
        }

        private boolean isPlainMap(XType returnType) {
            if (!MapType.isMap(returnType)) {
                return false;
            }
            MapType mapType = MapType.from(returnType);
            return !mapType.isRawType() && !XTypes.isWildcard((XType)mapType.valueType()) && !FrameworkTypes.isFrameworkType(mapType.valueType());
        }

        private boolean isPlainSet(XType returnType) {
            if (!SetType.isSet(returnType)) {
                return false;
            }
            SetType setType = SetType.from(returnType);
            return !setType.isRawType() && !XTypes.isWildcard((XType)setType.elementType()) && !FrameworkTypes.isFrameworkType(setType.elementType());
        }
    }
}

