/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.kotlin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.kotlin.KotlinMetadata;
import dagger.internal.codegen.kotlin.KotlinMetadataFactory;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.spi.shaded.auto.common.AnnotationMirrors;
import dagger.spi.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import kotlin.Metadata;
import kotlinx.metadata.Flag;

public final class KotlinMetadataUtil {
    private final KotlinMetadataFactory metadataFactory;

    @Inject
    KotlinMetadataUtil(KotlinMetadataFactory metadataFactory) {
        this.metadataFactory = metadataFactory;
    }

    public boolean hasMetadata(Element element) {
        return MoreElements.isAnnotationPresent((Element)DaggerElements.closestEnclosingTypeElement(element), Metadata.class);
    }

    public ImmutableCollection<? extends AnnotationMirror> getSyntheticPropertyAnnotations(VariableElement fieldElement, Class<? extends Annotation> annotationType) {
        return (ImmutableCollection)this.metadataFactory.create(fieldElement).getSyntheticAnnotationMethod(fieldElement).map(methodElement -> AnnotationMirrors.getAnnotatedAnnotations((Element)methodElement, (Class)annotationType).asList()).orElse(ImmutableList.of());
    }

    public boolean isMissingSyntheticPropertyForAnnotations(VariableElement fieldElement) {
        return this.metadataFactory.create(fieldElement).isMissingSyntheticAnnotationMethod(fieldElement);
    }

    public boolean isObjectClass(TypeElement typeElement) {
        return this.hasMetadata(typeElement) && this.metadataFactory.create(typeElement).classMetadata().flags(Flag.Class.IS_OBJECT);
    }

    public boolean isDataClass(TypeElement typeElement) {
        return this.hasMetadata(typeElement) && this.metadataFactory.create(typeElement).classMetadata().flags(Flag.Class.IS_DATA);
    }

    public boolean isCompanionObjectClass(TypeElement typeElement) {
        return this.hasMetadata(typeElement) && this.metadataFactory.create(typeElement).classMetadata().flags(Flag.Class.IS_COMPANION_OBJECT);
    }

    public boolean isObjectOrCompanionObjectClass(TypeElement typeElement) {
        return this.isObjectClass(typeElement) || this.isCompanionObjectClass(typeElement);
    }

    public boolean hasEnclosedCompanionObject(TypeElement typeElement) {
        return this.hasMetadata(typeElement) && this.metadataFactory.create(typeElement).classMetadata().companionObjectName().isPresent();
    }

    public TypeElement getEnclosedCompanionObject(TypeElement typeElement) {
        return this.metadataFactory.create(typeElement).classMetadata().companionObjectName().map(companionObjectName -> (TypeElement)ElementFilter.typesIn(typeElement.getEnclosedElements()).stream().filter(innerType -> innerType.getSimpleName().contentEquals((CharSequence)companionObjectName)).collect(DaggerCollectors.onlyElement())).get();
    }

    public boolean isVisibilityPrivate(TypeElement typeElement) {
        return this.hasMetadata(typeElement) && this.metadataFactory.create(typeElement).classMetadata().flags(Flag.IS_PRIVATE);
    }

    public boolean isVisibilityInternal(TypeElement type) {
        return this.hasMetadata(type) && this.metadataFactory.create(type).classMetadata().flags(Flag.IS_INTERNAL);
    }

    public boolean isVisibilityInternal(ExecutableElement method) {
        return this.hasMetadata(method) && this.metadataFactory.create(method).getFunctionMetadata(method).flags(Flag.IS_INTERNAL);
    }

    public Optional<ExecutableElement> getPropertyGetter(VariableElement fieldElement) {
        return this.metadataFactory.create(fieldElement).getPropertyGetter(fieldElement);
    }

    public boolean containsConstructorWithDefaultParam(TypeElement typeElement) {
        return this.hasMetadata(typeElement) && this.metadataFactory.create(typeElement).containsConstructorWithDefaultParam();
    }

    public ImmutableMap<String, String> getAllMethodNamesBySignature(TypeElement element) {
        Preconditions.checkState((boolean)this.hasMetadata(element), (Object)"Can not call getAllMethodNamesBySignature for non-Kotlin class");
        return (ImmutableMap)this.metadataFactory.create(element).classMetadata().functionsBySignature().values().stream().collect(DaggerStreams.toImmutableMap(KotlinMetadata.FunctionMetadata::signature, KotlinMetadata.BaseMetadata::name));
    }
}

