/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.DependencyVariableNamer;
import dagger.internal.codegen.binding.FrameworkField;
import dagger.internal.codegen.binding.FrameworkTypeMapper;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.RequestKind;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreElements;
import java.util.List;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class SourceFiles {
    private static final Joiner CLASS_FILE_NAME_JOINER = Joiner.on((char)'_');

    public static ImmutableMap<DependencyRequest, FrameworkField> generateBindingFieldsForDependencies(Binding binding) {
        Preconditions.checkArgument((!binding.unresolved().isPresent() ? 1 : 0) != 0, (String)"binding must be unresolved: %s", (Object)binding);
        FrameworkTypeMapper frameworkTypeMapper = FrameworkTypeMapper.forBindingType(binding.bindingType());
        return Maps.toMap(binding.dependencies(), dependency -> FrameworkField.create(frameworkTypeMapper.getFrameworkType(dependency.kind()).frameworkClassName(), TypeName.get((TypeMirror)dependency.key().type().java()), DependencyVariableNamer.name(dependency)));
    }

    public static CodeBlock frameworkTypeUsageStatement(CodeBlock frameworkTypeMemberSelect, RequestKind dependencyKind) {
        switch (dependencyKind) {
            case LAZY: {
                return CodeBlock.of((String)"$T.lazy($L)", (Object[])new Object[]{TypeNames.DOUBLE_CHECK, frameworkTypeMemberSelect});
            }
            case INSTANCE: 
            case FUTURE: {
                return CodeBlock.of((String)"$L.get()", (Object[])new Object[]{frameworkTypeMemberSelect});
            }
            case PROVIDER: 
            case PRODUCER: {
                return frameworkTypeMemberSelect;
            }
            case PROVIDER_OF_LAZY: {
                return CodeBlock.of((String)"$T.create($L)", (Object[])new Object[]{TypeNames.PROVIDER_OF_LAZY, frameworkTypeMemberSelect});
            }
        }
        throw new AssertionError(dependencyKind);
    }

    public static ImmutableMap<DependencyRequest, CodeBlock> frameworkFieldUsages(ImmutableSet<DependencyRequest> dependencies, ImmutableMap<DependencyRequest, FieldSpec> fields) {
        return Maps.toMap(dependencies, dep -> SourceFiles.frameworkTypeUsageStatement(CodeBlock.of((String)"$N", (Object[])new Object[]{fields.get(dep)}), dep.kind()));
    }

    public static ClassName generatedClassNameForBinding(Binding binding) {
        switch (binding.bindingType()) {
            case PROVISION: 
            case PRODUCTION: {
                ContributionBinding contribution = (ContributionBinding)binding;
                switch (contribution.kind()) {
                    case ASSISTED_INJECTION: 
                    case INJECTION: 
                    case PROVISION: 
                    case PRODUCTION: {
                        return SourceFiles.elementBasedClassName(MoreElements.asExecutable((Element)XConverters.toJavac((XElement)binding.bindingElement().get())), "Factory");
                    }
                    case ASSISTED_FACTORY: {
                        return SourceFiles.siblingClassName(MoreElements.asType((Element)XConverters.toJavac((XElement)binding.bindingElement().get())), "_Impl");
                    }
                }
                throw new AssertionError();
            }
            case MEMBERS_INJECTION: {
                return SourceFiles.membersInjectorNameForType(((MembersInjectionBinding)binding).membersInjectedType());
            }
        }
        throw new AssertionError();
    }

    public static ClassName elementBasedClassName(ExecutableElement element, String suffix) {
        ClassName enclosingClassName = ClassName.get((TypeElement)MoreElements.asType((Element)element.getEnclosingElement()));
        String methodName = element.getKind().equals((Object)ElementKind.CONSTRUCTOR) ? "" : CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, element.getSimpleName().toString());
        return ClassName.get((String)enclosingClassName.packageName(), (String)(SourceFiles.classFileName(enclosingClassName) + "_" + methodName + suffix), (String[])new String[0]);
    }

    public static TypeName parameterizedGeneratedTypeNameForBinding(Binding binding) {
        ClassName className = SourceFiles.generatedClassNameForBinding(binding);
        ImmutableList<TypeVariableName> typeParameters = SourceFiles.bindingTypeElementTypeVariableNames(binding);
        return typeParameters.isEmpty() ? className : ParameterizedTypeName.get((ClassName)className, (TypeName[])((TypeName[])Iterables.toArray(typeParameters, TypeName.class)));
    }

    public static ClassName membersInjectorNameForType(XTypeElement typeElement) {
        return SourceFiles.membersInjectorNameForType(XConverters.toJavac((XTypeElement)typeElement));
    }

    public static ClassName membersInjectorNameForType(TypeElement typeElement) {
        return SourceFiles.siblingClassName(typeElement, "_MembersInjector");
    }

    public static String memberInjectedFieldSignatureForVariable(VariableElement variableElement) {
        return MoreElements.asType((Element)variableElement.getEnclosingElement()).getQualifiedName() + "." + variableElement.getSimpleName();
    }

    public static String classFileName(ClassName className) {
        return CLASS_FILE_NAME_JOINER.join((Iterable)className.simpleNames());
    }

    public static ClassName generatedMonitoringModuleName(XTypeElement componentElement) {
        return SourceFiles.siblingClassName(XConverters.toJavac((XTypeElement)componentElement), "_MonitoringModule");
    }

    private static ClassName siblingClassName(TypeElement typeElement, String suffix) {
        ClassName className = ClassName.get((TypeElement)typeElement);
        return className.topLevelClassName().peerClass(SourceFiles.classFileName(className) + suffix);
    }

    public static ClassName setFactoryClassName(ContributionBinding binding) {
        Preconditions.checkArgument((boolean)binding.kind().equals((Object)BindingKind.MULTIBOUND_SET));
        if (binding.bindingType().equals((Object)BindingType.PROVISION)) {
            return TypeNames.SET_FACTORY;
        }
        SetType setType = SetType.from(binding.key());
        return setType.elementsAreTypeOf(TypeNames.PRODUCED) ? TypeNames.SET_OF_PRODUCED_PRODUCER : TypeNames.SET_PRODUCER;
    }

    public static ClassName mapFactoryClassName(ContributionBinding binding) {
        Preconditions.checkState((boolean)binding.kind().equals((Object)BindingKind.MULTIBOUND_MAP), (Object)binding.kind());
        MapType mapType = MapType.from(binding.key());
        switch (binding.bindingType()) {
            case PROVISION: {
                return mapType.valuesAreTypeOf(TypeNames.PROVIDER) ? TypeNames.MAP_PROVIDER_FACTORY : TypeNames.MAP_FACTORY;
            }
            case PRODUCTION: {
                return mapType.valuesAreFrameworkType() ? (mapType.valuesAreTypeOf(TypeNames.PRODUCER) ? TypeNames.MAP_OF_PRODUCER_PRODUCER : TypeNames.MAP_OF_PRODUCED_PRODUCER) : TypeNames.MAP_PRODUCER;
            }
        }
        throw new IllegalArgumentException(binding.bindingType().toString());
    }

    public static ImmutableList<TypeVariableName> bindingTypeElementTypeVariableNames(Binding binding) {
        ContributionBinding contributionBinding;
        if (binding instanceof ContributionBinding && (contributionBinding = (ContributionBinding)binding).kind() != BindingKind.INJECTION && contributionBinding.kind() != BindingKind.ASSISTED_INJECTION && !contributionBinding.requiresModuleInstance()) {
            return ImmutableList.of();
        }
        List<? extends TypeParameterElement> typeParameters = XConverters.toJavac((XTypeElement)binding.bindingTypeElement().get()).getTypeParameters();
        return (ImmutableList)typeParameters.stream().map(TypeVariableName::get).collect(DaggerStreams.toImmutableList());
    }

    public static String simpleVariableName(TypeElement typeElement) {
        return SourceFiles.simpleVariableName(ClassName.get((TypeElement)typeElement));
    }

    public static String simpleVariableName(ClassName className) {
        String candidateName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, className.simpleName());
        String variableName = SourceFiles.protectAgainstKeywords(candidateName);
        Verify.verify((boolean)SourceVersion.isName(variableName), (String)"'%s' was expected to be a valid variable name", (Object[])new Object[0]);
        return variableName;
    }

    public static String protectAgainstKeywords(String candidateName) {
        switch (candidateName) {
            case "package": {
                return "pkg";
            }
            case "boolean": {
                return "b";
            }
            case "double": {
                return "d";
            }
            case "byte": {
                return "b";
            }
            case "int": {
                return "i";
            }
            case "short": {
                return "s";
            }
            case "char": {
                return "c";
            }
            case "void": {
                return "v";
            }
            case "class": {
                return "clazz";
            }
            case "float": {
                return "f";
            }
            case "long": {
                return "l";
            }
        }
        return SourceVersion.isKeyword(candidateName) ? candidateName + '_' : candidateName;
    }

    private SourceFiles() {
    }
}

