/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.MoreAnnotationMirrors;
import dagger.internal.codegen.binding.ComponentCreatorAnnotation;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.shaded.androidx.room.compiler.processing.XElement;
import dagger.shaded.androidx.room.compiler.processing.XType;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public final class ConfigurationAnnotations {
    public static Optional<XTypeElement> getSubcomponentCreator(XTypeElement subcomponent) {
        Preconditions.checkArgument((boolean)ComponentAnnotation.subcomponentAnnotation(subcomponent).isPresent());
        return subcomponent.getEnclosedTypeElements().stream().filter(ConfigurationAnnotations::isSubcomponentCreator).findFirst();
    }

    static boolean isSubcomponentCreator(XElement element) {
        return XElements.hasAnyAnnotation((XAnnotated)element, ComponentCreatorAnnotation.subcomponentCreatorAnnotations());
    }

    public static ImmutableList<TypeMirror> getModuleInjects(AnnotationMirror moduleAnnotation) {
        Preconditions.checkNotNull((Object)moduleAnnotation);
        return MoreAnnotationMirrors.getTypeListValue(moduleAnnotation, "injects");
    }

    public static Optional<XAnnotation> getNullableAnnotation(XElement element) {
        return element.getAllAnnotations().stream().filter(annotation -> annotation.getName().contentEquals("Nullable")).findFirst();
    }

    public static Optional<XType> getNullableType(XElement element) {
        return ConfigurationAnnotations.getNullableAnnotation(element).map(XAnnotation::getType);
    }

    public static Optional<DeclaredType> getNullableType(Element element) {
        List<? extends AnnotationMirror> mirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            if (!annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals("Nullable")) continue;
            return Optional.of(annotationMirror.getAnnotationType());
        }
        return Optional.empty();
    }

    public static ImmutableSet<XTypeElement> enclosedAnnotatedTypes(XTypeElement typeElement2, ImmutableSet<ClassName> annotations2) {
        return (ImmutableSet)typeElement2.getEnclosedTypeElements().stream().filter(enclosedType -> XElements.hasAnyAnnotation((XAnnotated)enclosedType, (Collection<ClassName>)annotations2)).collect(DaggerStreams.toImmutableSet());
    }

    private ConfigurationAnnotations() {
    }
}

