/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.Binds;
import dagger.BindsOptionalOf;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.FrameworkTypes;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.OptionalType;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.base.SimpleAnnotationMirror;
import dagger.internal.codegen.binding.DelegateDeclaration;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.extension.Optionals;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.producers.Production;
import dagger.producers.internal.ProductionImplementation;
import dagger.producers.monitoring.ProductionComponentMonitor;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.DaggerType;
import dagger.spi.model.Key;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;

public final class KeyFactory {
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    KeyFactory(DaggerTypes types, DaggerElements elements, InjectionAnnotations injectionAnnotations) {
        this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
        this.elements = (DaggerElements)Preconditions.checkNotNull((Object)elements);
        this.injectionAnnotations = injectionAnnotations;
    }

    private TypeMirror boxPrimitives(TypeMirror type2) {
        return type2.getKind().isPrimitive() ? this.types.boxedClass((PrimitiveType)type2).asType() : type2;
    }

    private DeclaredType setOf(TypeMirror elementType) {
        return this.types.getDeclaredType(this.elements.getTypeElement(Set.class), this.boxPrimitives(elementType));
    }

    private DeclaredType mapOf(TypeMirror keyType, TypeMirror valueType) {
        return this.types.getDeclaredType(this.elements.getTypeElement(Map.class), this.boxPrimitives(keyType), this.boxPrimitives(valueType));
    }

    private TypeMirror mapOfFrameworkType(TypeMirror keyType, TypeElement frameworkType, TypeMirror valueType) {
        return this.mapOf(keyType, this.types.getDeclaredType(frameworkType, this.boxPrimitives(valueType)));
    }

    Key forComponentMethod(ExecutableElement componentMethod) {
        Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
        return this.forMethod(componentMethod, componentMethod.getReturnType());
    }

    Key forProductionComponentMethod(ExecutableElement componentMethod) {
        Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
        TypeMirror returnType2 = componentMethod.getReturnType();
        TypeMirror keyType = DaggerTypes.isFutureType(returnType2) ? (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(returnType2).getTypeArguments()) : returnType2;
        return this.forMethod(componentMethod, keyType);
    }

    Key forSubcomponentCreatorMethod(ExecutableElement subcomponentCreatorMethod, DeclaredType declaredContainer) {
        Preconditions.checkArgument((boolean)subcomponentCreatorMethod.getKind().equals((Object)ElementKind.METHOD));
        ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(declaredContainer, subcomponentCreatorMethod));
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)resolvedMethod.getReturnType())).build();
    }

    public Key forSubcomponentCreator(TypeMirror creatorType) {
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)creatorType)).build();
    }

    public Key forProvidesMethod(ExecutableElement method, TypeElement contributingModule) {
        return this.forBindingMethod(method, contributingModule, Optional.of(this.elements.getTypeElement(Provider.class)));
    }

    public Key forProducesMethod(ExecutableElement method, TypeElement contributingModule) {
        return this.forBindingMethod(method, contributingModule, Optional.of(this.elements.getTypeElement(Producer.class)));
    }

    Key forBindsMethod(ExecutableElement method, TypeElement contributingModule) {
        Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(method, Binds.class));
        return this.forBindingMethod(method, contributingModule, Optional.empty());
    }

    Key forBindsOptionalOfMethod(ExecutableElement method, TypeElement contributingModule) {
        Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(method, BindsOptionalOf.class));
        return this.forBindingMethod(method, contributingModule, Optional.empty());
    }

    private Key forBindingMethod(ExecutableElement method, TypeElement contributingModule, Optional<TypeElement> frameworkType) {
        Preconditions.checkArgument((boolean)method.getKind().equals((Object)ElementKind.METHOD));
        ExecutableType methodType = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(contributingModule.asType()), method));
        ContributionType contributionType = ContributionType.fromBindingElement(method);
        TypeMirror returnType2 = methodType.getReturnType();
        if (frameworkType.isPresent() && frameworkType.get().equals(this.elements.getTypeElement(Producer.class)) && MoreTypes.isType(returnType2)) {
            SetType setType;
            if (DaggerTypes.isFutureType(methodType.getReturnType())) {
                returnType2 = (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(returnType2).getTypeArguments());
            } else if (contributionType.equals((Object)ContributionType.SET_VALUES) && SetType.isSet(returnType2) && DaggerTypes.isFutureType((setType = SetType.from(returnType2)).elementType())) {
                returnType2 = this.types.getDeclaredType(this.elements.getTypeElement(Set.class), DaggerTypes.unwrapType(setType.elementType()));
            }
        }
        TypeMirror keyType = this.bindingMethodKeyType(returnType2, method, contributionType, frameworkType);
        Key key = this.forMethod(method, keyType);
        return contributionType.equals((Object)ContributionType.UNIQUE) ? key : key.toBuilder().multibindingContributionIdentifier(new Key.MultibindingContributionIdentifier(method, contributingModule)).build();
    }

    Key forMultibindsMethod(ExecutableType executableType2, ExecutableElement method) {
        Preconditions.checkArgument((boolean)method.getKind().equals((Object)ElementKind.METHOD), (String)"%s must be a method", (Object)method);
        TypeMirror returnType2 = executableType2.getReturnType();
        TypeMirror keyType = MapType.isMap(returnType2) ? this.mapOfFrameworkType(MapType.from(returnType2).keyType(), this.elements.getTypeElement(Provider.class), MapType.from(returnType2).valueType()) : returnType2;
        return this.forMethod(method, keyType);
    }

    private TypeMirror bindingMethodKeyType(TypeMirror returnType2, ExecutableElement method, ContributionType contributionType, Optional<TypeElement> frameworkType) {
        switch (contributionType) {
            case UNIQUE: {
                return returnType2;
            }
            case SET: {
                return this.setOf(returnType2);
            }
            case MAP: {
                TypeMirror mapKeyType = MapKeys.mapKeyType(MapKeys.getMapKey(method).get(), this.types);
                return frameworkType.isPresent() ? this.mapOfFrameworkType(mapKeyType, frameworkType.get(), returnType2) : this.mapOf(mapKeyType, returnType2);
            }
            case SET_VALUES: {
                Preconditions.checkArgument((boolean)SetType.isSet(returnType2));
                return returnType2;
            }
        }
        throw new AssertionError();
    }

    Key forDelegateBinding(DelegateDeclaration delegateDeclaration, Class<?> frameworkType) {
        return delegateDeclaration.contributionType().equals((Object)ContributionType.MAP) ? this.wrapMapValue(delegateDeclaration.key(), frameworkType) : delegateDeclaration.key();
    }

    private Key forMethod(ExecutableElement method, TypeMirror keyType) {
        return this.forQualifiedType(this.injectionAnnotations.getQualifier(method), keyType);
    }

    public Key forInjectConstructorWithResolvedType(TypeMirror type2) {
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)type2)).build();
    }

    Key forType(TypeMirror type2) {
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)type2)).build();
    }

    public Key forMembersInjectedType(TypeMirror type2) {
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)type2)).build();
    }

    Key forQualifiedType(Optional<AnnotationMirror> qualifier, TypeMirror type2) {
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)this.boxPrimitives(type2))).qualifier(qualifier.map(DaggerAnnotation::fromJava)).build();
    }

    public Key forProductionExecutor() {
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)this.elements.getTypeElement(Executor.class).asType())).qualifier(DaggerAnnotation.fromJava((AnnotationMirror)SimpleAnnotationMirror.of(this.elements.getTypeElement(Production.class)))).build();
    }

    public Key forProductionImplementationExecutor() {
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)this.elements.getTypeElement(Executor.class).asType())).qualifier(DaggerAnnotation.fromJava((AnnotationMirror)SimpleAnnotationMirror.of(this.elements.getTypeElement(ProductionImplementation.class)))).build();
    }

    public Key forProductionComponentMonitor() {
        return Key.builder((DaggerType)DaggerType.fromJava((TypeMirror)this.elements.getTypeElement(ProductionComponentMonitor.class).asType())).build();
    }

    ImmutableSet<Key> implicitFrameworkMapKeys(Key requestKey) {
        return (ImmutableSet)Stream.of(this.implicitMapProviderKeyFrom(requestKey), this.implicitMapProducerKeyFrom(requestKey)).filter(Optional::isPresent).map(Optional::get).collect(DaggerStreams.toImmutableSet());
    }

    Optional<Key> implicitMapProviderKeyFrom(Key possibleMapKey) {
        return Optionals.firstPresent(this.rewrapMapKey(possibleMapKey, Produced.class, Provider.class), this.wrapMapKey(possibleMapKey, Provider.class), (Optional[])new Optional[0]);
    }

    Optional<Key> implicitMapProducerKeyFrom(Key possibleMapKey) {
        return Optionals.firstPresent(this.rewrapMapKey(possibleMapKey, Produced.class, Producer.class), this.wrapMapKey(possibleMapKey, Producer.class), (Optional[])new Optional[0]);
    }

    public Key unwrapMapValueType(Key key) {
        MapType mapType;
        if (MapType.isMap(key) && !(mapType = MapType.from(key)).isRawType()) {
            for (Class frameworkClass : Arrays.asList(Provider.class, Producer.class, Produced.class)) {
                if (!mapType.valuesAreTypeOf(frameworkClass)) continue;
                return key.toBuilder().type(DaggerType.fromJava((TypeMirror)this.mapOf(mapType.keyType(), mapType.unwrappedValueType(frameworkClass)))).build();
            }
        }
        return key;
    }

    private Key wrapMapValue(Key key, Class<?> newWrappingClass) {
        Preconditions.checkArgument((boolean)FrameworkTypes.isFrameworkType(this.elements.getTypeElement(newWrappingClass).asType()));
        return this.wrapMapKey(key, newWrappingClass).get();
    }

    public Optional<Key> rewrapMapKey(Key possibleMapKey, Class<?> currentWrappingClass, Class<?> newWrappingClass) {
        MapType mapType;
        Preconditions.checkArgument((!currentWrappingClass.equals(newWrappingClass) ? 1 : 0) != 0);
        if (MapType.isMap(possibleMapKey) && !(mapType = MapType.from(possibleMapKey)).isRawType() && mapType.valuesAreTypeOf(currentWrappingClass)) {
            TypeElement wrappingElement = this.elements.getTypeElement(newWrappingClass);
            if (wrappingElement == null) {
                return Optional.empty();
            }
            DeclaredType wrappedValueType = this.types.getDeclaredType(wrappingElement, mapType.unwrappedValueType(currentWrappingClass));
            return Optional.of(possibleMapKey.toBuilder().type(DaggerType.fromJava((TypeMirror)this.mapOf(mapType.keyType(), wrappedValueType))).build());
        }
        return Optional.empty();
    }

    private Optional<Key> wrapMapKey(Key possibleMapKey, Class<?> wrappingClass) {
        MapType mapType;
        if (MapType.isMap(possibleMapKey) && !(mapType = MapType.from(possibleMapKey)).isRawType() && !mapType.valuesAreTypeOf(wrappingClass)) {
            TypeElement wrappingElement = this.elements.getTypeElement(wrappingClass);
            if (wrappingElement == null) {
                return Optional.empty();
            }
            DeclaredType wrappedValueType = this.types.getDeclaredType(wrappingElement, mapType.valueType());
            return Optional.of(possibleMapKey.toBuilder().type(DaggerType.fromJava((TypeMirror)this.mapOf(mapType.keyType(), wrappedValueType))).build());
        }
        return Optional.empty();
    }

    Optional<Key> unwrapSetKey(Key key, Class<?> wrappingClass) {
        SetType setType;
        if (SetType.isSet(key) && !(setType = SetType.from(key)).isRawType() && setType.elementsAreTypeOf(wrappingClass)) {
            return Optional.of(key.toBuilder().type(DaggerType.fromJava((TypeMirror)this.setOf(setType.unwrappedElementType(wrappingClass)))).build());
        }
        return Optional.empty();
    }

    Optional<Key> unwrapOptional(Key key) {
        if (!OptionalType.isOptional(key)) {
            return Optional.empty();
        }
        TypeMirror optionalValueType = OptionalType.from(key).valueType();
        return Optional.of(key.toBuilder().type(DaggerType.fromJava((TypeMirror)RequestKinds.extractKeyType(optionalValueType))).build());
    }
}

