/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.codegen.base.ElementFormatter;
import dagger.internal.codegen.base.Formatter;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.DependencyRequest;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor8;

public final class DependencyRequestFormatter
extends Formatter<DependencyRequest> {
    private final DaggerTypes types;
    private final ElementVisitor<String, DependencyRequest> formatVisitor = new ElementKindVisitor8<String, DependencyRequest>(){

        @Override
        public String visitExecutableAsMethod(ExecutableElement method, DependencyRequest request) {
            return "    " + request.key() + " is " + DependencyRequestFormatter.this.componentMethodRequestVerb(request) + " at\n" + "        " + ElementFormatter.elementToString(method);
        }

        @Override
        public String visitVariable(VariableElement variable, DependencyRequest request) {
            TypeMirror requestedType = RequestKinds.requestType(request.kind(), request.key().type().java(), DependencyRequestFormatter.this.types);
            return "    " + DependencyRequestFormatter.this.formatQualifier(request.key().qualifier()) + requestedType + " is injected at\n" + "        " + ElementFormatter.elementToString(variable);
        }

        @Override
        public String visitType(TypeElement e, DependencyRequest request) {
            return "";
        }

        @Override
        protected String defaultAction(Element element, DependencyRequest request) {
            throw new IllegalStateException("Invalid request " + (Object)((Object)element.getKind()) + " element " + element);
        }
    };

    @Inject
    DependencyRequestFormatter(DaggerTypes types) {
        this.types = types;
    }

    @Override
    public String format(DependencyRequest request) {
        return request.requestElement().map(element -> element.java().accept(this.formatVisitor, request)).orElse("");
    }

    @CanIgnoreReturnValue
    public StringBuilder appendFormatLine(StringBuilder builder, DependencyRequest dependencyRequest) {
        String formatted = this.format(dependencyRequest);
        if (!formatted.isEmpty()) {
            builder.append('\n').append(formatted);
        }
        return builder;
    }

    private String formatQualifier(Optional<DaggerAnnotation> maybeQualifier) {
        return maybeQualifier.map(qualifier -> qualifier + " ").orElse("");
    }

    private String componentMethodRequestVerb(DependencyRequest request) {
        switch (request.kind()) {
            case FUTURE: 
            case PRODUCER: 
            case INSTANCE: 
            case LAZY: 
            case PROVIDER: 
            case PROVIDER_OF_LAZY: {
                return "requested";
            }
            case MEMBERS_INJECTION: {
                return "injected";
            }
        }
        throw new AssertionError((Object)("illegal request kind for method: " + request));
    }
}

