/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.ComponentCreatorAnnotation;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptorFactory;
import dagger.internal.codegen.validation.ComponentCreatorValidator;
import dagger.internal.codegen.validation.ComponentValidator;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.androidx.room.compiler.processing.XMessager;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.MoreElements;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.TypeElement;

final class ComponentHjarProcessingStep
extends TypeCheckingProcessingStep<XTypeElement> {
    private final XMessager messager;
    private final ComponentValidator componentValidator;
    private final ComponentCreatorValidator creatorValidator;
    private final ComponentDescriptorFactory componentDescriptorFactory;
    private final SourceFileGenerator<ComponentDescriptor> componentGenerator;

    @Inject
    ComponentHjarProcessingStep(XMessager messager2, ComponentValidator componentValidator, ComponentCreatorValidator creatorValidator, ComponentDescriptorFactory componentDescriptorFactory, SourceFileGenerator<ComponentDescriptor> componentGenerator) {
        this.messager = messager2;
        this.componentValidator = componentValidator;
        this.creatorValidator = creatorValidator;
        this.componentDescriptorFactory = componentDescriptorFactory;
        this.componentGenerator = componentGenerator;
    }

    @Override
    public Set<ClassName> annotationClassNames() {
        return Sets.union(ComponentAnnotation.rootComponentAnnotations(), ComponentCreatorAnnotation.rootComponentCreatorAnnotations());
    }

    @Override
    protected void process(XTypeElement xElement, ImmutableSet<ClassName> annotations2) {
        TypeElement element = XConverters.toJavac(xElement);
        if (!Collections.disjoint(annotations2, ComponentAnnotation.rootComponentAnnotations())) {
            this.processRootComponent(element);
        }
        if (!Collections.disjoint(annotations2, ComponentCreatorAnnotation.rootComponentCreatorAnnotations())) {
            this.processRootCreator(element);
        }
    }

    private void processRootComponent(TypeElement element) {
        ValidationReport validationReport = this.componentValidator.validate(element);
        validationReport.printMessagesTo(this.messager);
        if (validationReport.isClean()) {
            this.componentGenerator.generate(this.componentDescriptorFactory.rootComponentDescriptor(element), this.messager);
        }
    }

    private void processRootCreator(TypeElement creator) {
        this.creatorValidator.validate(MoreElements.asType(creator)).printMessagesTo(this.messager);
    }
}

