/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.shaded.androidx.room.compiler.processing.XElement;
import dagger.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.shaded.androidx.room.compiler.processing.XProcessingStep;
import java.util.Map;
import java.util.Set;

public abstract class XTypeCheckingProcessingStep<E extends XElement>
implements XProcessingStep {
    public final ImmutableSet<String> annotations() {
        return (ImmutableSet)this.annotationClassNames().stream().map(ClassName::canonicalName).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<XElement> process(XProcessingEnv env, Map<String, ? extends Set<? extends XElement>> elementsByAnnotation) {
        ImmutableSet.Builder deferredElements = ImmutableSet.builder();
        this.inverse(elementsByAnnotation).forEach((element, annotations2) -> {
            try {
                this.process(element, (ImmutableSet<ClassName>)annotations2);
            }
            catch (TypeNotPresentException e) {
                deferredElements.add(element);
            }
        });
        return deferredElements.build();
    }

    protected abstract void process(E var1, ImmutableSet<ClassName> var2);

    private ImmutableMap<XElement, ImmutableSet<ClassName>> inverse(Map<String, ? extends Set<? extends XElement>> elementsByAnnotation) {
        ImmutableMap annotationClassNames = (ImmutableMap)this.annotationClassNames().stream().collect(DaggerStreams.toImmutableMap(ClassName::canonicalName, className2 -> className2));
        Preconditions.checkState((boolean)annotationClassNames.keySet().containsAll(elementsByAnnotation.keySet()), (String)"Unexpected annotations for %s: %s", (Object)this.getClass().getName(), (Object)Sets.difference(elementsByAnnotation.keySet(), (Set)annotationClassNames.keySet()));
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        elementsByAnnotation.forEach((annotationName, elementSet) -> elementSet.forEach(element -> builder.put(element, (Object)((ClassName)annotationClassNames.get(annotationName)))));
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)builder.build().asMap(), ImmutableSet::copyOf));
    }

    protected abstract Set<ClassName> annotationClassNames();
}

