/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Traverser;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import dagger.internal.codegen.base.ElementFormatter;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.validation.AutoValue_ValidationReport_Item;
import java.util.Optional;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public final class ValidationReport<T extends Element> {
    private static final Traverser<ValidationReport<?>> SUBREPORTS = Traverser.forTree(report -> report.subreports);
    private final T subject;
    private final ImmutableSet<Item> items;
    private final ImmutableSet<ValidationReport<?>> subreports;
    private final boolean markedDirty;
    private boolean hasPrintedErrors;

    private ValidationReport(T subject, ImmutableSet<Item> items, ImmutableSet<ValidationReport<?>> subreports, boolean markedDirty) {
        this.subject = subject;
        this.items = items;
        this.subreports = subreports;
        this.markedDirty = markedDirty;
    }

    public ImmutableSet<Item> allItems() {
        return (ImmutableSet)ImmutableSet.copyOf((Iterable)SUBREPORTS.depthFirstPreOrder((Object)this)).stream().flatMap(report -> report.items.stream()).collect(DaggerStreams.toImmutableSet());
    }

    public boolean isClean() {
        if (this.markedDirty) {
            return false;
        }
        for (Item item : this.items) {
            switch (item.kind()) {
                case ERROR: {
                    return false;
                }
            }
        }
        for (ValidationReport subreport : this.subreports) {
            if (subreport.isClean()) continue;
            return false;
        }
        return true;
    }

    public void printMessagesTo(Messager messager2) {
        if (this.hasPrintedErrors) {
            return;
        }
        this.hasPrintedErrors = true;
        for (Item item : this.items) {
            if (ValidationReport.isEnclosedIn(this.subject, item.element())) {
                if (item.annotation().isPresent()) {
                    if (item.annotationValue().isPresent()) {
                        messager2.printMessage(item.kind(), item.message(), item.element(), item.annotation().get(), item.annotationValue().get());
                        continue;
                    }
                    messager2.printMessage(item.kind(), item.message(), item.element(), item.annotation().get());
                    continue;
                }
                messager2.printMessage(item.kind(), item.message(), item.element());
                continue;
            }
            String message = String.format("[%s] %s", ElementFormatter.elementToString(item.element()), item.message());
            messager2.printMessage(item.kind(), message, (Element)this.subject);
        }
        for (ValidationReport subreport : this.subreports) {
            subreport.printMessagesTo(messager2);
        }
    }

    private static boolean isEnclosedIn(Element parent, Element child) {
        for (Element current = child; current != null; current = current.getEnclosingElement()) {
            if (!current.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Element> Builder<T> about(T subject) {
        return new Builder(subject, null);
    }

    /* synthetic */ ValidationReport(Element x0, ImmutableSet x1, ImmutableSet x2, boolean x3, 1 x4) {
        this(x0, (ImmutableSet<Item>)x1, x2, x3);
    }

    @CanIgnoreReturnValue
    public static final class Builder<T extends Element> {
        private final T subject;
        private final ImmutableSet.Builder<Item> items = ImmutableSet.builder();
        private final ImmutableSet.Builder<ValidationReport<?>> subreports = ImmutableSet.builder();
        private boolean markedDirty;

        private Builder(T subject) {
            this.subject = subject;
        }

        @CheckReturnValue
        T getSubject() {
            return this.subject;
        }

        Builder<T> addItems(Iterable<Item> newItems) {
            this.items.addAll(newItems);
            return this;
        }

        public Builder<T> addError(String message) {
            return this.addError(message, (Element)this.subject);
        }

        public Builder<T> addError(String message, Element element) {
            return this.addItem(message, Diagnostic.Kind.ERROR, element);
        }

        public Builder<T> addError(String message, Element element, AnnotationMirror annotation) {
            return this.addItem(message, Diagnostic.Kind.ERROR, element, annotation);
        }

        public Builder<T> addError(String message, Element element, AnnotationMirror annotation, AnnotationValue annotationValue) {
            return this.addItem(message, Diagnostic.Kind.ERROR, element, annotation, annotationValue);
        }

        Builder<T> addWarning(String message) {
            return this.addWarning(message, (Element)this.subject);
        }

        Builder<T> addWarning(String message, Element element) {
            return this.addItem(message, Diagnostic.Kind.WARNING, element);
        }

        Builder<T> addWarning(String message, Element element, AnnotationMirror annotation) {
            return this.addItem(message, Diagnostic.Kind.WARNING, element, annotation);
        }

        Builder<T> addWarning(String message, Element element, AnnotationMirror annotation, AnnotationValue annotationValue) {
            return this.addItem(message, Diagnostic.Kind.WARNING, element, annotation, annotationValue);
        }

        Builder<T> addNote(String message) {
            return this.addNote(message, (Element)this.subject);
        }

        Builder<T> addNote(String message, Element element) {
            return this.addItem(message, Diagnostic.Kind.NOTE, element);
        }

        Builder<T> addNote(String message, Element element, AnnotationMirror annotation) {
            return this.addItem(message, Diagnostic.Kind.NOTE, element, annotation);
        }

        Builder<T> addNote(String message, Element element, AnnotationMirror annotation, AnnotationValue annotationValue) {
            return this.addItem(message, Diagnostic.Kind.NOTE, element, annotation, annotationValue);
        }

        Builder<T> addItem(String message, Diagnostic.Kind kind, Element element) {
            return this.addItem(message, kind, element, Optional.empty(), Optional.empty());
        }

        Builder<T> addItem(String message, Diagnostic.Kind kind, Element element, AnnotationMirror annotation) {
            return this.addItem(message, kind, element, Optional.of(annotation), Optional.empty());
        }

        Builder<T> addItem(String message, Diagnostic.Kind kind, Element element, AnnotationMirror annotation, AnnotationValue annotationValue) {
            return this.addItem(message, kind, element, Optional.of(annotation), Optional.of(annotationValue));
        }

        private Builder<T> addItem(String message, Diagnostic.Kind kind, Element element, Optional<AnnotationMirror> annotation, Optional<AnnotationValue> annotationValue) {
            this.items.add((Object)new AutoValue_ValidationReport_Item(message, kind, element, annotation, annotationValue));
            return this;
        }

        void markDirty() {
            this.markedDirty = true;
        }

        public Builder<T> addSubreport(ValidationReport<?> subreport) {
            this.subreports.add(subreport);
            return this;
        }

        @CheckReturnValue
        public ValidationReport<T> build() {
            return new ValidationReport((Element)this.subject, this.items.build(), this.subreports.build(), this.markedDirty, null);
        }

        /* synthetic */ Builder(Element x0, 1 x1) {
            this(x0);
        }
    }

    @AutoValue
    public static abstract class Item {
        public abstract String message();

        public abstract Diagnostic.Kind kind();

        public abstract Element element();

        public abstract Optional<AnnotationMirror> annotation();

        abstract Optional<AnnotationValue> annotationValue();
    }
}

