/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.writing.AssistedFactoryBindingExpression;
import dagger.internal.codegen.writing.BindingExpression;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentInstanceBindingExpression;
import dagger.internal.codegen.writing.ComponentProvisionBindingExpression;
import dagger.internal.codegen.writing.ComponentRequirementBindingExpression;
import dagger.internal.codegen.writing.DelegateBindingExpression;
import dagger.internal.codegen.writing.MapBindingExpression;
import dagger.internal.codegen.writing.OptionalBindingExpression;
import dagger.internal.codegen.writing.SetBindingExpression;
import dagger.internal.codegen.writing.SimpleMethodBindingExpression;
import dagger.internal.codegen.writing.SubcomponentCreatorBindingExpression;
import dagger.model.RequestKind;
import java.util.Optional;
import javax.inject.Inject;

final class UnscopedDirectInstanceBindingExpressionFactory {
    private final AssistedFactoryBindingExpression.Factory assistedFactoryBindingExpressionFactory;
    private final ComponentInstanceBindingExpression.Factory componentInstanceBindingExpressionFactory;
    private final ComponentProvisionBindingExpression.Factory componentProvisionBindingExpressionFactory;
    private final ComponentRequirementBindingExpression.Factory componentRequirementBindingExpressionFactory;
    private final DelegateBindingExpression.Factory delegateBindingExpressionFactory;
    private final MapBindingExpression.Factory mapBindingExpressionFactory;
    private final OptionalBindingExpression.Factory optionalBindingExpressionFactory;
    private final SetBindingExpression.Factory setBindingExpressionFactory;
    private final SimpleMethodBindingExpression.Factory simpleMethodBindingExpressionFactory;
    private final SubcomponentCreatorBindingExpression.Factory subcomponentCreatorBindingExpressionFactory;

    @Inject
    UnscopedDirectInstanceBindingExpressionFactory(ComponentImplementation componentImplementation, AssistedFactoryBindingExpression.Factory assistedFactoryBindingExpressionFactory, ComponentInstanceBindingExpression.Factory componentInstanceBindingExpressionFactory, ComponentProvisionBindingExpression.Factory componentProvisionBindingExpressionFactory, ComponentRequirementBindingExpression.Factory componentRequirementBindingExpressionFactory, DelegateBindingExpression.Factory delegateBindingExpressionFactory, MapBindingExpression.Factory mapBindingExpressionFactory, OptionalBindingExpression.Factory optionalBindingExpressionFactory, SetBindingExpression.Factory setBindingExpressionFactory, SimpleMethodBindingExpression.Factory simpleMethodBindingExpressionFactory, SubcomponentCreatorBindingExpression.Factory subcomponentCreatorBindingExpressionFactory) {
        this.assistedFactoryBindingExpressionFactory = assistedFactoryBindingExpressionFactory;
        this.componentInstanceBindingExpressionFactory = componentInstanceBindingExpressionFactory;
        this.componentProvisionBindingExpressionFactory = componentProvisionBindingExpressionFactory;
        this.componentRequirementBindingExpressionFactory = componentRequirementBindingExpressionFactory;
        this.delegateBindingExpressionFactory = delegateBindingExpressionFactory;
        this.mapBindingExpressionFactory = mapBindingExpressionFactory;
        this.optionalBindingExpressionFactory = optionalBindingExpressionFactory;
        this.setBindingExpressionFactory = setBindingExpressionFactory;
        this.simpleMethodBindingExpressionFactory = simpleMethodBindingExpressionFactory;
        this.subcomponentCreatorBindingExpressionFactory = subcomponentCreatorBindingExpressionFactory;
    }

    Optional<BindingExpression> create(ContributionBinding binding) {
        switch (binding.kind()) {
            case DELEGATE: {
                return Optional.of(this.delegateBindingExpressionFactory.create(binding, RequestKind.INSTANCE));
            }
            case COMPONENT: {
                return Optional.of(this.componentInstanceBindingExpressionFactory.create(binding));
            }
            case COMPONENT_DEPENDENCY: {
                return Optional.of(this.componentRequirementBindingExpressionFactory.create(binding, ComponentRequirement.forDependency(binding.key().type())));
            }
            case COMPONENT_PROVISION: {
                return Optional.of(this.componentProvisionBindingExpressionFactory.create((ProvisionBinding)binding));
            }
            case SUBCOMPONENT_CREATOR: {
                return Optional.of(this.subcomponentCreatorBindingExpressionFactory.create(binding));
            }
            case MULTIBOUND_SET: {
                return Optional.of(this.setBindingExpressionFactory.create((ProvisionBinding)binding));
            }
            case MULTIBOUND_MAP: {
                return Optional.of(this.mapBindingExpressionFactory.create((ProvisionBinding)binding));
            }
            case OPTIONAL: {
                return Optional.of(this.optionalBindingExpressionFactory.create((ProvisionBinding)binding));
            }
            case BOUND_INSTANCE: {
                return Optional.of(this.componentRequirementBindingExpressionFactory.create(binding, ComponentRequirement.forBoundInstance(binding)));
            }
            case ASSISTED_FACTORY: {
                return Optional.of(this.assistedFactoryBindingExpressionFactory.create((ProvisionBinding)binding));
            }
            case ASSISTED_INJECTION: 
            case INJECTION: 
            case PROVISION: {
                return Optional.of(this.simpleMethodBindingExpressionFactory.create((ProvisionBinding)binding));
            }
            case MEMBERS_INJECTOR: {
                return Optional.empty();
            }
        }
        throw new AssertionError((Object)("Unexpected binding kind: " + binding.kind()));
    }
}

