/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.BindingExpression;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.MethodBindingExpression;
import dagger.model.BindingKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class PrivateMethodBindingExpression
extends MethodBindingExpression {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final ContributionBinding binding;
    private final BindingRequest request;
    private final CompilerOptions compilerOptions;
    private final DaggerTypes types;
    private String methodName;

    @AssistedInject
    PrivateMethodBindingExpression(@Assisted BindingRequest request, @Assisted ContributionBinding binding, @Assisted MethodBindingExpression.MethodImplementationStrategy methodImplementationStrategy, @Assisted BindingExpression wrappedBindingExpression, ComponentImplementation componentImplementation, DaggerTypes types, CompilerOptions compilerOptions) {
        super(componentImplementation.shardImplementation(binding), request, binding, methodImplementationStrategy, wrappedBindingExpression, types);
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.binding = binding;
        this.request = request;
        this.compilerOptions = compilerOptions;
        this.types = types;
    }

    @Override
    protected void addMethod() {
        if (this.methodName == null) {
            this.methodName = this.shardImplementation.getUniqueMethodName(this.request);
            this.shardImplementation.addMethod(ComponentImplementation.MethodSpecKind.PRIVATE_METHOD, MethodSpec.methodBuilder((String)this.methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameters((Iterable)(this.binding.kind() == BindingKind.ASSISTED_INJECTION ? AssistedInjectionAnnotations.assistedParameterSpecs(this.binding, this.types) : ImmutableList.of())).returns(TypeName.get((TypeMirror)this.returnType())).addCode(this.methodBody()).build());
        }
    }

    @Override
    protected String methodName() {
        Preconditions.checkState((this.methodName != null ? 1 : 0) != 0, (Object)"addMethod() must be called before methodName()");
        return this.methodName;
    }

    @AssistedFactory
    static interface Factory {
        public PrivateMethodBindingExpression create(BindingRequest var1, ContributionBinding var2, MethodBindingExpression.MethodImplementationStrategy var3, BindingExpression var4);
    }
}

