/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.DiagnosticFormatting;
import dagger.internal.codegen.base.SimpleAnnotationMirror;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.model.Scope;
import dagger.producers.ProductionScope;
import dagger.shaded.auto.common.AnnotationMirrors;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public final class Scopes {
    public static Scope productionScope(DaggerElements elements) {
        return Scopes.scope(elements, ProductionScope.class);
    }

    public static Scope singletonScope(DaggerElements elements) {
        return Scopes.scope(elements, Singleton.class);
    }

    private static Scope scope(DaggerElements elements, Class<? extends Annotation> scopeAnnotationClass) {
        return Scope.scope((AnnotationMirror)SimpleAnnotationMirror.of(elements.getTypeElement(scopeAnnotationClass)));
    }

    public static Optional<Scope> uniqueScopeOf(Element element) {
        return Optional.ofNullable((Scope)Iterables.getOnlyElement(Scopes.scopesOf(element), null));
    }

    public static String getReadableSource(Scope scope) {
        return DiagnosticFormatting.stripCommonTypePrefixes(scope.toString());
    }

    public static ImmutableSet<Scope> scopesOf(Element element) {
        return (ImmutableSet)AnnotationMirrors.getAnnotatedAnnotations(element, javax.inject.Scope.class).stream().map(Scope::scope).collect(DaggerStreams.toImmutableSet());
    }
}

