/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.binding.AutoValue_BindingRequest;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.RequestKind;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;

@AutoValue
public abstract class BindingRequest {
    public static BindingRequest bindingRequest(DependencyRequest dependencyRequest) {
        return BindingRequest.bindingRequest(dependencyRequest.key(), dependencyRequest.kind());
    }

    public static BindingRequest bindingRequest(Key key, RequestKind requestKind) {
        return new AutoValue_BindingRequest(key, Optional.of(requestKind), FrameworkType.forRequestKind(requestKind));
    }

    public static BindingRequest bindingRequest(Key key, FrameworkType frameworkType) {
        return new AutoValue_BindingRequest(key, frameworkType.requestKind(), Optional.of(frameworkType));
    }

    public abstract Key key();

    public abstract Optional<RequestKind> requestKind();

    public abstract Optional<FrameworkType> frameworkType();

    public final boolean isRequestKind(RequestKind requestKind) {
        return requestKind.equals(this.requestKind().orElse(null));
    }

    public final TypeMirror requestedType(TypeMirror contributedType, DaggerTypes types) {
        if (this.requestKind().isPresent()) {
            return RequestKinds.requestType(this.requestKind().get(), contributedType, types);
        }
        return types.wrapType(contributedType, this.frameworkType().get().frameworkClass());
    }

    public final String kindName() {
        RequestKind requestKindObject = this.requestKind().isPresent() ? this.requestKind().get() : this.frameworkType().get().frameworkClass().getSimpleName();
        return requestKindObject.toString();
    }
}

