/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.BindsInstance;
import dagger.internal.codegen.ComponentGenerator;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.ComponentCreatorAnnotation;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentCreatorKind;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptorFactory;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.MethodSignature;
import dagger.internal.codegen.javapoet.TypeSpecs;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.ComponentCreatorValidator;
import dagger.internal.codegen.validation.ComponentValidator;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.producers.internal.CancellationListener;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Types;

final class ComponentHjarProcessingStep
extends TypeCheckingProcessingStep<TypeElement> {
    private final SourceVersion sourceVersion;
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final Filer filer;
    private final Messager messager;
    private final ComponentValidator componentValidator;
    private final ComponentCreatorValidator creatorValidator;
    private final ComponentDescriptorFactory componentDescriptorFactory;
    private final KotlinMetadataUtil metadataUtil;
    private ImmutableMap<Element, ValidationReport<TypeElement>> creatorReportsByComponent;

    @Inject
    ComponentHjarProcessingStep(SourceVersion sourceVersion, DaggerElements elements, DaggerTypes types, Filer filer, Messager messager, ComponentValidator componentValidator, ComponentCreatorValidator creatorValidator, ComponentDescriptorFactory componentDescriptorFactory, KotlinMetadataUtil metadataUtil) {
        super(MoreElements::asType);
        this.sourceVersion = sourceVersion;
        this.elements = elements;
        this.types = types;
        this.filer = filer;
        this.messager = messager;
        this.componentValidator = componentValidator;
        this.creatorValidator = creatorValidator;
        this.componentDescriptorFactory = componentDescriptorFactory;
        this.metadataUtil = metadataUtil;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return Sets.union(ComponentAnnotation.rootComponentAnnotations(), ComponentCreatorAnnotation.rootComponentCreatorAnnotations());
    }

    @Override
    public ImmutableSet<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        this.creatorReportsByComponent = this.creatorReportsByComponent(elementsByAnnotation);
        return super.process(elementsByAnnotation);
    }

    @Override
    protected void process(TypeElement element, ImmutableSet<Class<? extends Annotation>> annotations) {
        if (!Collections.disjoint(annotations, ComponentCreatorAnnotation.rootComponentCreatorAnnotations())) {
            return;
        }
        if (this.creatorReportsByComponent.containsKey((Object)element) && !((ValidationReport)this.creatorReportsByComponent.get((Object)element)).isClean()) {
            return;
        }
        ComponentValidator.ComponentValidationReport validationReport = this.componentValidator.validate(element, (Set<? extends Element>)ImmutableSet.of(), (Set<? extends Element>)ImmutableSet.of());
        validationReport.report().printMessagesTo(this.messager);
        if (validationReport.report().isClean()) {
            new EmptyComponentGenerator(this.filer, this.elements, this.sourceVersion).generate(this.componentDescriptorFactory.rootComponentDescriptor(element), this.messager);
        }
    }

    private ImmutableMap<Element, ValidationReport<TypeElement>> creatorReportsByComponent(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        ImmutableSet creatorElements = ImmutableSet.copyOf((Collection)Multimaps.filterKeys(elementsByAnnotation, (Predicate)Predicates.in(ComponentCreatorAnnotation.rootComponentCreatorAnnotations())).values());
        HashMap<Element, ValidationReport<TypeElement>> reports = new HashMap<Element, ValidationReport<TypeElement>>();
        for (Element element : creatorElements) {
            ValidationReport<TypeElement> report = this.creatorValidator.validate(MoreElements.asType(element));
            report.printMessagesTo(this.messager);
            reports.put(element.getEnclosingElement(), report);
        }
        return ImmutableMap.copyOf(reports);
    }

    private MethodSpec emptyComponentMethod(TypeElement typeElement, ExecutableElement baseMethod) {
        return MethodSpec.overriding((ExecutableElement)baseMethod, (DeclaredType)MoreTypes.asDeclared(typeElement.asType()), (Types)this.types).build();
    }

    private MethodSpec privateConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    private Stream<ComponentRequirement> componentRequirements(ComponentDescriptor component) {
        Preconditions.checkArgument((!component.isSubcomponent() ? 1 : 0) != 0);
        return Stream.concat(component.dependencies().stream(), component.modules().stream().filter(module -> !module.moduleElement().getModifiers().contains((Object)Modifier.ABSTRACT) && Accessibility.isElementAccessibleFrom((Element)module.moduleElement(), ClassName.get((TypeElement)component.typeElement()).packageName())).map(module -> ComponentRequirement.forModule(module.moduleElement().asType())));
    }

    private boolean hasBindsInstanceMethods(ComponentDescriptor componentDescriptor) {
        return componentDescriptor.creatorDescriptor().isPresent() && this.elements.getUnimplementedMethods(componentDescriptor.creatorDescriptor().get().typeElement()).stream().anyMatch(method -> ComponentHjarProcessingStep.isBindsInstance(method));
    }

    private static boolean isBindsInstance(ExecutableElement method) {
        if (MoreElements.isAnnotationPresent(method, BindsInstance.class)) {
            return true;
        }
        if (method.getParameters().size() == 1) {
            return MoreElements.isAnnotationPresent(method.getParameters().get(0), BindsInstance.class);
        }
        return false;
    }

    private MethodSpec builderSetterMethod(TypeElement componentRequirement, ClassName builderClass) {
        String simpleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, componentRequirement.getSimpleName().toString());
        return MethodSpec.methodBuilder((String)simpleName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((TypeElement)componentRequirement), simpleName, new Modifier[0]).returns((TypeName)builderClass).build();
    }

    private MethodSpec builderBuildMethod(ComponentDescriptor component) {
        return MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((TypeElement)component.typeElement())).build();
    }

    private MethodSpec staticCreatorMethod(TypeName creatorMethodReturnType, ComponentCreatorKind creatorKind) {
        return MethodSpec.methodBuilder((String)Ascii.toLowerCase((String)creatorKind.typeName())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(creatorMethodReturnType).build();
    }

    private MethodSpec createMethod(ComponentDescriptor componentDescriptor) {
        return MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassName.get((TypeElement)componentDescriptor.typeElement())).build();
    }

    private MethodSpec onProducerFutureCancelledMethod() {
        return MethodSpec.methodBuilder((String)"onProducerFutureCancelled").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.BOOLEAN, "mayInterruptIfRunning", new Modifier[0]).build();
    }

    private final class EmptyComponentGenerator
    extends SourceFileGenerator<ComponentDescriptor> {
        EmptyComponentGenerator(Filer filer, DaggerElements elements, SourceVersion sourceVersion) {
            super(filer, elements, sourceVersion);
        }

        @Override
        public ClassName nameGeneratedType(ComponentDescriptor input) {
            return ComponentGenerator.componentName(input.typeElement());
        }

        @Override
        public Element originatingElement(ComponentDescriptor input) {
            return input.typeElement();
        }

        @Override
        public Optional<TypeSpec.Builder> write(ComponentDescriptor componentDescriptor) {
            boolean noArgFactoryMethod;
            ComponentCreatorKind creatorKind;
            ClassName builderMethodReturnType;
            ClassName generatedTypeName = this.nameGeneratedType(componentDescriptor);
            TypeSpec.Builder generatedComponent = TypeSpec.classBuilder((ClassName)generatedTypeName).addModifiers(new Modifier[]{Modifier.FINAL}).addMethod(ComponentHjarProcessingStep.this.privateConstructor());
            if (componentDescriptor.typeElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
                generatedComponent.addModifiers(new Modifier[]{Modifier.PUBLIC});
            }
            TypeElement componentElement = componentDescriptor.typeElement();
            TypeSpecs.addSupertype(generatedComponent, componentElement);
            if (componentDescriptor.creatorDescriptor().isPresent()) {
                ComponentCreatorDescriptor creatorDescriptor = componentDescriptor.creatorDescriptor().get();
                builderMethodReturnType = ClassName.get((TypeElement)creatorDescriptor.typeElement());
                creatorKind = creatorDescriptor.kind();
                noArgFactoryMethod = creatorDescriptor.factoryParameters().isEmpty();
            } else {
                ClassName builderClassName;
                TypeSpec.Builder builder = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL}).addMethod(ComponentHjarProcessingStep.this.privateConstructor());
                if (componentDescriptor.typeElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
                    builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
                }
                builderMethodReturnType = builderClassName = generatedTypeName.nestedClass("Builder");
                creatorKind = ComponentCreatorKind.BUILDER;
                noArgFactoryMethod = true;
                ComponentHjarProcessingStep.this.componentRequirements(componentDescriptor).map(requirement -> ComponentHjarProcessingStep.this.builderSetterMethod(requirement.typeElement(), builderClassName)).forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
                builder.addMethod(ComponentHjarProcessingStep.this.builderBuildMethod(componentDescriptor));
                generatedComponent.addType(builder.build());
            }
            generatedComponent.addMethod(ComponentHjarProcessingStep.this.staticCreatorMethod((TypeName)builderMethodReturnType, creatorKind));
            if (noArgFactoryMethod && !ComponentHjarProcessingStep.this.hasBindsInstanceMethods(componentDescriptor) && ComponentHjarProcessingStep.this.componentRequirements(componentDescriptor).noneMatch(requirement -> requirement.requiresAPassedInstance(ComponentHjarProcessingStep.this.elements, ComponentHjarProcessingStep.this.types, ComponentHjarProcessingStep.this.metadataUtil))) {
                generatedComponent.addMethod(ComponentHjarProcessingStep.this.createMethod(componentDescriptor));
            }
            DeclaredType componentType = MoreTypes.asDeclared(componentElement.asType());
            HashSet methodSignatures = Sets.newHashSetWithExpectedSize((int)componentDescriptor.componentMethods().size());
            componentDescriptor.componentMethods().stream().filter(method -> methodSignatures.add(MethodSignature.forComponentMethod(method, componentType, ComponentHjarProcessingStep.this.types))).forEach(method -> generatedComponent.addMethod(ComponentHjarProcessingStep.this.emptyComponentMethod(componentElement, method.methodElement())));
            if (componentDescriptor.isProduction()) {
                generatedComponent.addSuperinterface((TypeName)ClassName.get(CancellationListener.class)).addMethod(ComponentHjarProcessingStep.this.onProducerFutureCancelledMethod());
            }
            return Optional.of(generatedComponent);
        }
    }
}

