/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.Preconditions;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.binding.ConfigurationAnnotations;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.InjectionMethod;
import dagger.model.DependencyRequest;
import dagger.model.RequestKind;
import dagger.shaded.auto.common.MoreElements;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class InjectionMethods {
    InjectionMethods() {
    }

    private static ImmutableList<CodeBlock> injectionMethodArguments(ImmutableSet<DependencyRequest> dependencies, Function<DependencyRequest, CodeBlock> dependencyUsage, ClassName requestingClass) {
        return (ImmutableList)dependencies.stream().map(dep -> InjectionMethods.injectionMethodArgument(dep, (CodeBlock)dependencyUsage.apply((DependencyRequest)dep), requestingClass)).collect(DaggerStreams.toImmutableList());
    }

    private static CodeBlock injectionMethodArgument(DependencyRequest dependency, CodeBlock argument, ClassName generatedTypeName) {
        TypeMirror keyType = dependency.key().type();
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        if (!Accessibility.isRawTypeAccessible(keyType, generatedTypeName.packageName()) && Accessibility.isTypeAccessibleFrom(keyType, generatedTypeName.packageName())) {
            if (!dependency.kind().equals((Object)RequestKind.INSTANCE)) {
                TypeName usageTypeName = InjectionMethods.accessibleType(dependency);
                codeBlock.add("($T) ($T)", new Object[]{usageTypeName, TypeNames.rawTypeName(usageTypeName)});
            } else if (((Element)dependency.requestElement().get()).asType().getKind().equals((Object)TypeKind.TYPEVAR)) {
                codeBlock.add("($T)", new Object[]{keyType});
            }
        }
        return codeBlock.add(argument).build();
    }

    private static TypeName accessibleType(DependencyRequest dependency) {
        TypeName typeName = RequestKinds.requestTypeName(dependency.kind(), InjectionMethods.accessibleType(dependency.key().type()));
        return dependency.requestElement().map(element -> element.asType().getKind().isPrimitive()).orElse(false) != false ? typeName.unbox() : typeName;
    }

    private static TypeName accessibleType(TypeMirror type) {
        return Accessibility.isRawTypePubliclyAccessible(type) ? TypeName.get((TypeMirror)type) : TypeName.OBJECT;
    }

    private static TypeMirror accessibleType(TypeMirror type, DaggerElements elements) {
        return Accessibility.isRawTypePubliclyAccessible(type) ? type : elements.getTypeElement(Object.class).asType();
    }

    private static CodeBlock instanceWithPotentialCast(CodeBlock instance, TypeMirror instanceType) {
        return Accessibility.isRawTypePubliclyAccessible(instanceType) ? instance : CodeBlock.of((String)"(($T) $L)", (Object[])new Object[]{instanceType, instance});
    }

    private static InjectionMethod methodProxy(ClassName proxyEnclosingClass, ExecutableElement method, String methodName, ReceiverAccessibility receiverAccessibility, CheckNotNullPolicy checkNotNullPolicy, DaggerElements elements, KotlinMetadataUtil metadataUtil) {
        TypeElement enclosingType = MoreElements.asType(method.getEnclosingElement());
        boolean isMethodInKotlinObject = metadataUtil.isObjectClass(enclosingType);
        InjectionMethod.Builder injectionMethod = InjectionMethod.builder(elements).name(methodName).enclosingClass(proxyEnclosingClass);
        ParameterSpec instance = null;
        if (!isMethodInKotlinObject && !method.getModifiers().contains((Object)Modifier.STATIC)) {
            instance = injectionMethod.addParameter("instance", receiverAccessibility.parameterType(enclosingType.asType(), elements));
        }
        CodeBlock arguments = injectionMethod.copyParameters(method);
        if (!method.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
            injectionMethod.returnType(method.getReturnType()).nullableAnnotation(ConfigurationAnnotations.getNullableType(method));
            injectionMethod.methodBodyBuilder().add("return ", new Object[0]);
        }
        CodeBlock.Builder proxyInvocation = CodeBlock.builder();
        if (isMethodInKotlinObject) {
            proxyInvocation.add("$T.INSTANCE", new Object[]{TypeNames.rawTypeName(TypeName.get((TypeMirror)enclosingType.asType()))});
        } else if (method.getModifiers().contains((Object)Modifier.STATIC)) {
            proxyInvocation.add("$T", new Object[]{TypeNames.rawTypeName(TypeName.get((TypeMirror)enclosingType.asType()))});
        } else {
            injectionMethod.copyTypeParameters(enclosingType);
            proxyInvocation.add(receiverAccessibility.potentiallyCast(CodeBlock.of((String)"$N", (Object[])new Object[]{instance}), enclosingType.asType()));
        }
        injectionMethod.copyTypeParameters(method).copyThrows(method);
        proxyInvocation.add(".$N($L)", new Object[]{method.getSimpleName(), arguments});
        injectionMethod.methodBodyBuilder().add(checkNotNullPolicy.checkForNull(proxyInvocation.build())).add(";\n", new Object[0]);
        return injectionMethod.build();
    }

    private static InjectionMethod fieldProxy(ClassName proxyEnclosingClass, VariableElement field, String methodName, DaggerElements elements) {
        TypeElement enclosingType = MoreElements.asType(field.getEnclosingElement());
        InjectionMethod.Builder injectionMethod = InjectionMethod.builder(elements).name(methodName).enclosingClass(proxyEnclosingClass);
        injectionMethod.copyTypeParameters(enclosingType);
        ParameterSpec instance = injectionMethod.addParameter("instance", InjectionMethods.accessibleType(enclosingType.asType(), elements));
        CodeBlock parameter = injectionMethod.copyParameter(field);
        injectionMethod.methodBodyBuilder().addStatement("$L.$L = $L", new Object[]{InjectionMethods.instanceWithPotentialCast(CodeBlock.of((String)"$N", (Object[])new Object[]{instance}), enclosingType.asType()), field.getSimpleName(), parameter});
        return injectionMethod.build();
    }

    private static enum CheckNotNullPolicy {
        IGNORE,
        CHECK_FOR_NULL;


        CodeBlock checkForNull(CodeBlock maybeNull) {
            return this.equals((Object)IGNORE) ? maybeNull : CodeBlock.of((String)"$T.checkNotNull($L, $S)", (Object[])new Object[]{Preconditions.class, maybeNull, "Cannot return null from a non-@Nullable @Provides method"});
        }

        static CheckNotNullPolicy get(ProvisionBinding binding, CompilerOptions compilerOptions) {
            return binding.shouldCheckForNull(compilerOptions) ? CHECK_FOR_NULL : IGNORE;
        }
    }

    private static enum ReceiverAccessibility {
        CAST_IF_NOT_PUBLIC{

            @Override
            TypeMirror parameterType(TypeMirror type, DaggerElements elements) {
                return InjectionMethods.accessibleType(type, elements);
            }

            @Override
            CodeBlock potentiallyCast(CodeBlock instance, TypeMirror instanceType) {
                return InjectionMethods.instanceWithPotentialCast(instance, instanceType);
            }
        }
        ,
        IGNORE{

            @Override
            TypeMirror parameterType(TypeMirror type, DaggerElements elements) {
                return type;
            }

            @Override
            CodeBlock potentiallyCast(CodeBlock instance, TypeMirror instanceType) {
                return instance;
            }
        };


        abstract TypeMirror parameterType(TypeMirror var1, DaggerElements var2);

        abstract CodeBlock potentiallyCast(CodeBlock var1, TypeMirror var2);
    }

    static final class InjectionSiteMethod {
        InjectionSiteMethod() {
        }

        static InjectionMethod create(MembersInjectionBinding.InjectionSite injectionSite, DaggerElements elements, KotlinMetadataUtil metadataUtil) {
            String methodName = InjectionSiteMethod.methodName(injectionSite);
            ClassName proxyEnclosingClass = SourceFiles.membersInjectorNameForType(MoreElements.asType(injectionSite.element().getEnclosingElement()));
            switch (injectionSite.kind()) {
                case METHOD: {
                    return InjectionMethods.methodProxy(proxyEnclosingClass, MoreElements.asExecutable(injectionSite.element()), methodName, ReceiverAccessibility.CAST_IF_NOT_PUBLIC, CheckNotNullPolicy.IGNORE, elements, metadataUtil);
                }
                case FIELD: {
                    return InjectionMethods.fieldProxy(proxyEnclosingClass, MoreElements.asVariable(injectionSite.element()), methodName, elements);
                }
            }
            throw new AssertionError(injectionSite);
        }

        static CodeBlock invokeAll(ImmutableSet<MembersInjectionBinding.InjectionSite> injectionSites, ClassName generatedTypeName, CodeBlock instanceCodeBlock, TypeMirror instanceType, DaggerTypes types, Function<DependencyRequest, CodeBlock> dependencyUsage, DaggerElements elements, KotlinMetadataUtil metadataUtil) {
            return injectionSites.stream().map(injectionSite -> {
                TypeMirror injectSiteType = types.erasure(injectionSite.element().getEnclosingElement().asType());
                CodeBlock maybeCastedInstance = !types.isSubtype(instanceType, injectSiteType) && Accessibility.isTypeAccessibleFrom(injectSiteType, generatedTypeName.packageName()) ? CodeBlock.of((String)"($T) $L", (Object[])new Object[]{injectSiteType, instanceCodeBlock}) : instanceCodeBlock;
                return CodeBlock.of((String)"$L;", (Object[])new Object[]{InjectionSiteMethod.invoke(injectionSite, generatedTypeName, maybeCastedInstance, dependencyUsage, elements, metadataUtil)});
            }).collect(CodeBlocks.toConcatenatedCodeBlock());
        }

        private static CodeBlock invoke(MembersInjectionBinding.InjectionSite injectionSite, ClassName generatedTypeName, CodeBlock instanceCodeBlock, Function<DependencyRequest, CodeBlock> dependencyUsage, DaggerElements elements, KotlinMetadataUtil metadataUtil) {
            ArrayList<CodeBlock> arguments = new ArrayList<CodeBlock>();
            arguments.add(instanceCodeBlock);
            if (!injectionSite.dependencies().isEmpty()) {
                arguments.addAll(injectionSite.dependencies().stream().map(dependencyUsage).collect(Collectors.toList()));
            }
            return InjectionSiteMethod.create(injectionSite, elements, metadataUtil).invoke(arguments, generatedTypeName);
        }

        private static String methodName(MembersInjectionBinding.InjectionSite injectionSite) {
            int index = injectionSite.indexAmongAtInjectMembersWithSameSimpleName();
            String indexString = index == 0 ? "" : String.valueOf(index + 1);
            return "inject" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, injectionSite.element().getSimpleName().toString()) + indexString;
        }
    }

    static final class ProvisionMethod {
        private static final ImmutableSet<String> BANNED_PROXY_NAMES = ImmutableSet.of((Object)"get", (Object)"create");

        ProvisionMethod() {
        }

        static InjectionMethod create(ProvisionBinding binding, CompilerOptions compilerOptions, DaggerElements elements, KotlinMetadataUtil metadataUtil) {
            ClassName proxyEnclosingClass = SourceFiles.generatedClassNameForBinding(binding);
            ExecutableElement element = MoreElements.asExecutable(binding.bindingElement().get());
            switch (element.getKind()) {
                case CONSTRUCTOR: {
                    return ProvisionMethod.constructorProxy(proxyEnclosingClass, element, elements);
                }
                case METHOD: {
                    return InjectionMethods.methodProxy(proxyEnclosingClass, element, ProvisionMethod.methodName(element), ReceiverAccessibility.IGNORE, CheckNotNullPolicy.get(binding, compilerOptions), elements, metadataUtil);
                }
            }
            throw new AssertionError(element);
        }

        static CodeBlock invoke(ProvisionBinding binding, Function<DependencyRequest, CodeBlock> dependencyUsage, ClassName requestingClass, Optional<CodeBlock> moduleReference, CompilerOptions compilerOptions, DaggerElements elements, KotlinMetadataUtil metadataUtil) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            moduleReference.ifPresent(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
            arguments.addAll((Iterable)InjectionMethods.injectionMethodArguments((ImmutableSet<DependencyRequest>)binding.provisionDependencies(), dependencyUsage, requestingClass));
            return ProvisionMethod.create(binding, compilerOptions, elements, metadataUtil).invoke((List<CodeBlock>)arguments.build(), requestingClass);
        }

        private static InjectionMethod constructorProxy(ClassName proxyEnclosingClass, ExecutableElement constructor, DaggerElements elements) {
            TypeElement enclosingType = MoreElements.asType(constructor.getEnclosingElement());
            InjectionMethod.Builder injectionMethod = InjectionMethod.builder(elements).name(ProvisionMethod.methodName(constructor)).returnType(enclosingType.asType()).enclosingClass(proxyEnclosingClass);
            injectionMethod.copyTypeParameters(enclosingType).copyThrows(constructor);
            CodeBlock arguments = injectionMethod.copyParameters(constructor);
            injectionMethod.methodBodyBuilder().addStatement("return new $T($L)", new Object[]{enclosingType, arguments});
            return injectionMethod.build();
        }

        static boolean requiresInjectionMethod(ProvisionBinding binding, ImmutableList<Expression> arguments, CompilerOptions compilerOptions, String callingPackage, DaggerTypes types) {
            ExecutableElement method = MoreElements.asExecutable(binding.bindingElement().get());
            return !binding.injectionSites().isEmpty() || binding.shouldCheckForNull(compilerOptions) || !Accessibility.isElementAccessibleFrom((Element)method, callingPackage) || !ProvisionMethod.areParametersAssignable(method, arguments, types) || method.getParameters().stream().map(Element::asType).anyMatch(type -> !Accessibility.isRawTypeAccessible(type, callingPackage));
        }

        private static boolean areParametersAssignable(ExecutableElement element, ImmutableList<Expression> arguments, DaggerTypes types) {
            List<? extends VariableElement> parameters = element.getParameters();
            com.google.common.base.Preconditions.checkArgument((parameters.size() == arguments.size() ? 1 : 0) != 0);
            for (int i = 0; i < parameters.size(); ++i) {
                if (types.isAssignable(((Expression)arguments.get(i)).type(), parameters.get(i).asType())) continue;
                return false;
            }
            return true;
        }

        private static String methodName(ExecutableElement method) {
            switch (method.getKind()) {
                case CONSTRUCTOR: {
                    return "newInstance";
                }
                case METHOD: {
                    String methodName = method.getSimpleName().toString();
                    return BANNED_PROXY_NAMES.contains((Object)methodName) ? "proxy" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, methodName) : methodName;
                }
            }
            throw new AssertionError(method);
        }
    }
}

