/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.kotlin;

import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.kotlin.KotlinMetadata;
import dagger.internal.codegen.kotlin.KotlinMetadataFactory;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import kotlin.Metadata;

public final class KotlinMetadataUtil {
    private final KotlinMetadataFactory metadataFactory;

    @Inject
    KotlinMetadataUtil(KotlinMetadataFactory metadataFactory) {
        this.metadataFactory = metadataFactory;
    }

    public boolean hasMetadata(Element element) {
        return MoreElements.isAnnotationPresent(DaggerElements.closestEnclosingTypeElement(element), Metadata.class);
    }

    public ImmutableSet<? extends AnnotationMirror> getSyntheticPropertyAnnotations(VariableElement fieldElement, Class<? extends Annotation> annotationType) {
        return this.metadataFactory.create(fieldElement).flatMap(metadata -> metadata.getSyntheticAnnotationMethod(fieldElement)).map(methodElement -> AnnotationMirrors.getAnnotatedAnnotations(methodElement, annotationType)).orElse(ImmutableSet.of());
    }

    public boolean isObjectClass(TypeElement typeElement) {
        return this.metadataFactory.create(typeElement).map(KotlinMetadata::isObjectClass).orElse(false);
    }
}

