/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.kotlin;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.shaded.auto.common.MoreElements;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import kotlinx.metadata.Flag;
import kotlinx.metadata.KmClass;
import kotlinx.metadata.KmProperty;
import kotlinx.metadata.jvm.JvmExtensionsKt;
import kotlinx.metadata.jvm.JvmFieldSignature;
import kotlinx.metadata.jvm.JvmMethodSignature;

final class KotlinMetadata {
    private final TypeElement typeElement;
    private final KmClass kmClass;
    private final Supplier<Map<VariableElement, Optional<ExecutableElement>>> elementFieldAnnotationMethodMap;

    KotlinMetadata(TypeElement typeElement, KmClass kmClass) {
        this.typeElement = typeElement;
        this.kmClass = kmClass;
        this.elementFieldAnnotationMethodMap = Suppliers.memoize(() -> {
            HashMap propertyDescriptors = new HashMap();
            kmClass.getProperties().forEach(property -> {
                JvmFieldSignature signature = JvmExtensionsKt.getFieldSignature((KmProperty)property);
                if (signature != null) {
                    propertyDescriptors.put(signature.asString(), property);
                }
            });
            Map<String, ExecutableElement> methodDescriptors = ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().collect(Collectors.toMap(DaggerElements::getMethodDescriptor, method -> method));
            return ElementFilter.fieldsIn(typeElement.getEnclosedElements()).stream().filter(field -> MoreElements.isAnnotationPresent(field, Inject.class)).collect(Collectors.toMap(Function.identity(), field -> Optional.ofNullable((KmProperty)propertyDescriptors.get(DaggerElements.getFieldDescriptor(field))).map(JvmExtensionsKt::getSyntheticMethodForAnnotations).map(JvmMethodSignature::asString).map(methodDescriptors::get)));
        });
    }

    TypeElement getTypeElement() {
        return this.typeElement;
    }

    KmClass getKmClass() {
        return this.kmClass;
    }

    Optional<ExecutableElement> getSyntheticAnnotationMethod(VariableElement fieldElement) {
        Preconditions.checkArgument((boolean)((Map)this.elementFieldAnnotationMethodMap.get()).containsKey(fieldElement));
        return (Optional)((Map)this.elementFieldAnnotationMethodMap.get()).get(fieldElement);
    }

    boolean isObjectClass() {
        return Flag.Class.IS_OBJECT.invoke(this.kmClass.getFlags());
    }
}

