/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.Preconditions;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.javapoet.TypeSpecs;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.ComponentCreatorImplementation;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ModuleProxies;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public final class ComponentCreatorImplementationFactory {
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final KotlinMetadataUtil metadataUtil;

    @Inject
    ComponentCreatorImplementationFactory(DaggerElements elements, DaggerTypes types, KotlinMetadataUtil metadataUtil) {
        this.elements = elements;
        this.types = types;
        this.metadataUtil = metadataUtil;
    }

    Optional<ComponentCreatorImplementation> create(ComponentImplementation componentImplementation, Optional<BindingGraph> graph) {
        if (!componentImplementation.componentDescriptor().hasCreator()) {
            return Optional.empty();
        }
        Optional<ComponentCreatorDescriptor> creatorDescriptor = componentImplementation.componentDescriptor().creatorDescriptor();
        Builder builder = creatorDescriptor.isPresent() ? new BuilderForCreatorDescriptor(componentImplementation, creatorDescriptor.get(), graph) : new BuilderForGeneratedRootComponentBuilder(componentImplementation);
        return Optional.of(builder.build());
    }

    static enum RequirementStatus {
        NEEDED,
        UNNEEDED,
        UNSETTABLE_REPEATED_MODULE;

    }

    private final class BuilderForGeneratedRootComponentBuilder
    extends Builder {
        BuilderForGeneratedRootComponentBuilder(ComponentImplementation componentImplementation) {
            super(componentImplementation);
        }

        @Override
        protected ImmutableMap<ComponentRequirement, RequirementStatus> userSettableRequirements() {
            return Maps.toMap(this.setterMethods(), requirement -> this.componentConstructorRequirements().contains(requirement) ? RequirementStatus.NEEDED : RequirementStatus.UNNEEDED);
        }

        @Override
        protected Optional<Modifier> visibility() {
            return this.componentImplementation.componentDescriptor().typeElement().getModifiers().contains((Object)Modifier.PUBLIC) ? Optional.of(Modifier.PUBLIC) : Optional.empty();
        }

        @Override
        protected void setSupertype() {
        }

        @Override
        protected void addConstructor() {
            this.classBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        }

        @Override
        protected ImmutableSet<ComponentRequirement> setterMethods() {
            return this.componentDescriptor().dependenciesAndConcreteModules();
        }

        @Override
        protected ImmutableMap<ComponentRequirement, String> factoryMethodParameters() {
            return ImmutableMap.of();
        }

        @Override
        protected MethodSpec.Builder factoryMethodBuilder() {
            return MethodSpec.methodBuilder((String)"build");
        }

        @Override
        protected MethodSpec.Builder setterMethodBuilder(ComponentRequirement requirement) {
            String name = SourceFiles.simpleVariableName(requirement.typeElement());
            return MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.get((TypeMirror)requirement.type()), name, new Modifier[0]).returns((TypeName)this.className);
        }
    }

    private final class BuilderForCreatorDescriptor
    extends Builder {
        final ComponentCreatorDescriptor creatorDescriptor;
        private final Optional<BindingGraph> graph;

        BuilderForCreatorDescriptor(ComponentImplementation componentImplementation, ComponentCreatorDescriptor creatorDescriptor, Optional<BindingGraph> graph) {
            super(componentImplementation);
            this.creatorDescriptor = creatorDescriptor;
            this.graph = graph;
        }

        @Override
        protected ImmutableMap<ComponentRequirement, RequirementStatus> userSettableRequirements() {
            return Maps.toMap(this.creatorDescriptor.userSettableRequirements(), this::requirementStatus);
        }

        @Override
        protected Optional<Modifier> visibility() {
            return Optional.of(Modifier.PRIVATE);
        }

        @Override
        protected void setSupertype() {
            TypeSpecs.addSupertype(this.classBuilder, this.creatorDescriptor.typeElement());
        }

        @Override
        protected void addConstructor() {
        }

        @Override
        protected ImmutableSet<ComponentRequirement> setterMethods() {
            return ImmutableSet.copyOf((Collection)this.creatorDescriptor.setterMethods().keySet());
        }

        @Override
        protected ImmutableMap<ComponentRequirement, String> factoryMethodParameters() {
            return ImmutableMap.copyOf((Map)Maps.transformValues(this.creatorDescriptor.factoryParameters(), element -> element.getSimpleName().toString()));
        }

        private DeclaredType creatorType() {
            return MoreTypes.asDeclared(this.creatorDescriptor.typeElement().asType());
        }

        @Override
        protected MethodSpec.Builder factoryMethodBuilder() {
            return MethodSpec.overriding((ExecutableElement)this.creatorDescriptor.factoryMethod(), (DeclaredType)this.creatorType(), (Types)ComponentCreatorImplementationFactory.this.types);
        }

        private RequirementStatus requirementStatus(ComponentRequirement requirement) {
            if (this.isRepeatedModule(requirement)) {
                return RequirementStatus.UNSETTABLE_REPEATED_MODULE;
            }
            return this.componentConstructorRequirements().contains((Object)requirement) ? RequirementStatus.NEEDED : RequirementStatus.UNNEEDED;
        }

        final boolean isRepeatedModule(ComponentRequirement requirement) {
            return !this.componentConstructorRequirements().contains((Object)requirement) && !this.isOwnedModule(requirement);
        }

        private boolean isOwnedModule(ComponentRequirement requirement) {
            return this.graph.map(g -> g.ownedModuleTypes().contains((Object)requirement.typeElement())).orElse(true);
        }

        @Override
        protected MethodSpec.Builder setterMethodBuilder(ComponentRequirement requirement) {
            ExecutableElement supertypeMethod = (ExecutableElement)this.creatorDescriptor.setterMethods().get((Object)requirement);
            MethodSpec.Builder method = MethodSpec.overriding((ExecutableElement)supertypeMethod, (DeclaredType)this.creatorType(), (Types)ComponentCreatorImplementationFactory.this.types);
            if (!supertypeMethod.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
                method.returns((TypeName)this.className);
            }
            return method;
        }
    }

    private abstract class Builder {
        final ComponentImplementation componentImplementation;
        final ClassName className;
        final TypeSpec.Builder classBuilder;
        private ImmutableMap<ComponentRequirement, FieldSpec> fields;

        Builder(ComponentImplementation componentImplementation) {
            this.componentImplementation = componentImplementation;
            this.className = componentImplementation.getCreatorName();
            this.classBuilder = TypeSpec.classBuilder((ClassName)this.className);
        }

        ComponentCreatorImplementation build() {
            this.setModifiers();
            this.setSupertype();
            this.fields = this.addFields();
            this.addConstructor();
            this.addSetterMethods();
            this.addFactoryMethod();
            return ComponentCreatorImplementation.create(this.classBuilder.build(), this.className, this.fields);
        }

        final ComponentDescriptor componentDescriptor() {
            return this.componentImplementation.componentDescriptor();
        }

        final ImmutableSet<ComponentRequirement> componentConstructorRequirements() {
            return this.componentImplementation.graph().componentRequirements();
        }

        abstract ImmutableSet<ComponentRequirement> setterMethods();

        abstract ImmutableMap<ComponentRequirement, String> factoryMethodParameters();

        abstract ImmutableMap<ComponentRequirement, RequirementStatus> userSettableRequirements();

        private Set<ComponentRequirement> neededUserSettableRequirements() {
            return Sets.intersection((Set)this.userSettableRequirements().keySet(), this.componentConstructorRequirements());
        }

        private void setModifiers() {
            this.visibility().ifPresent(xva$0 -> this.classBuilder.addModifiers(new Modifier[]{xva$0}));
            if (!this.componentImplementation.isNested()) {
                this.classBuilder.addModifiers(new Modifier[]{Modifier.STATIC});
            }
            this.classBuilder.addModifiers(new Modifier[]{Modifier.FINAL});
        }

        protected abstract Optional<Modifier> visibility();

        protected abstract void setSupertype();

        protected abstract void addConstructor();

        private ImmutableMap<ComponentRequirement, FieldSpec> addFields() {
            UniqueNameSet fieldNames = new UniqueNameSet();
            ImmutableMap result = Maps.toMap((Iterable)Sets.intersection(this.neededUserSettableRequirements(), this.setterMethods()), requirement -> FieldSpec.builder((TypeName)TypeName.get((TypeMirror)requirement.type()), (String)fieldNames.getUniqueName(requirement.variableName()), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
            this.classBuilder.addFields((Iterable)result.values());
            return result;
        }

        private void addSetterMethods() {
            Maps.filterKeys(this.userSettableRequirements(), arg_0 -> this.setterMethods().contains(arg_0)).forEach((requirement, status) -> this.createSetterMethod((ComponentRequirement)requirement, (RequirementStatus)((Object)status)).ifPresent(arg_0 -> ((TypeSpec.Builder)this.classBuilder).addMethod(arg_0)));
        }

        protected abstract MethodSpec.Builder setterMethodBuilder(ComponentRequirement var1);

        private Optional<MethodSpec> createSetterMethod(ComponentRequirement requirement, RequirementStatus status) {
            switch (status) {
                case NEEDED: {
                    return Optional.of(this.normalSetterMethod(requirement));
                }
                case UNNEEDED: {
                    return Optional.of(this.noopSetterMethod(requirement));
                }
                case UNSETTABLE_REPEATED_MODULE: {
                    return Optional.of(this.repeatedModuleSetterMethod(requirement));
                }
            }
            throw new AssertionError();
        }

        private MethodSpec normalSetterMethod(ComponentRequirement requirement) {
            MethodSpec.Builder method = this.setterMethodBuilder(requirement);
            ParameterSpec parameter = this.parameter(method.build());
            method.addStatement("this.$N = $L", new Object[]{this.fields.get((Object)requirement), requirement.nullPolicy(ComponentCreatorImplementationFactory.this.elements, ComponentCreatorImplementationFactory.this.types, ComponentCreatorImplementationFactory.this.metadataUtil).equals((Object)ComponentRequirement.NullPolicy.ALLOW) ? CodeBlock.of((String)"$N", (Object[])new Object[]{parameter}) : CodeBlock.of((String)"$T.checkNotNull($N)", (Object[])new Object[]{Preconditions.class, parameter})});
            return this.maybeReturnThis(method);
        }

        private MethodSpec noopSetterMethod(ComponentRequirement requirement) {
            MethodSpec.Builder method = this.setterMethodBuilder(requirement);
            ParameterSpec parameter = this.parameter(method.build());
            method.addAnnotation(Deprecated.class).addJavadoc("@deprecated This module is declared, but an instance is not used in the component. This method is a no-op. For more, see https://dagger.dev/unused-modules.\n", new Object[0]).addStatement("$T.checkNotNull($N)", new Object[]{Preconditions.class, parameter});
            return this.maybeReturnThis(method);
        }

        private MethodSpec repeatedModuleSetterMethod(ComponentRequirement requirement) {
            return this.setterMethodBuilder(requirement).addStatement("throw new $T($T.format($S, $T.class.getCanonicalName()))", new Object[]{UnsupportedOperationException.class, String.class, "%s cannot be set because it is inherited from the enclosing component", TypeNames.rawTypeName(TypeName.get((TypeMirror)requirement.type()))}).build();
        }

        private ParameterSpec parameter(MethodSpec method) {
            return (ParameterSpec)Iterables.getOnlyElement((Iterable)method.parameters);
        }

        private MethodSpec maybeReturnThis(MethodSpec.Builder method) {
            MethodSpec built = method.build();
            return built.returnType.equals((Object)TypeName.VOID) ? built : method.addStatement("return this", new Object[0]).build();
        }

        private void addFactoryMethod() {
            this.classBuilder.addMethod(this.factoryMethod());
        }

        MethodSpec factoryMethod() {
            MethodSpec.Builder factoryMethod = this.factoryMethodBuilder();
            factoryMethod.returns((TypeName)ClassName.get((TypeElement)this.componentDescriptor().typeElement())).addModifiers(new Modifier[]{Modifier.PUBLIC});
            ImmutableMap<ComponentRequirement, String> factoryMethodParameters = this.factoryMethodParameters();
            this.userSettableRequirements().keySet().forEach(requirement -> {
                if (this.fields.containsKey(requirement)) {
                    FieldSpec field = (FieldSpec)this.fields.get(requirement);
                    this.addNullHandlingForField((ComponentRequirement)requirement, field, factoryMethod);
                } else if (factoryMethodParameters.containsKey(requirement)) {
                    String parameterName = (String)factoryMethodParameters.get(requirement);
                    this.addNullHandlingForParameter((ComponentRequirement)requirement, parameterName, factoryMethod);
                }
            });
            factoryMethod.addStatement("return new $T($L)", new Object[]{this.componentImplementation.name(), this.componentConstructorArgs(factoryMethodParameters)});
            return factoryMethod.build();
        }

        private void addNullHandlingForField(ComponentRequirement requirement, FieldSpec field, MethodSpec.Builder factoryMethod) {
            switch (requirement.nullPolicy(ComponentCreatorImplementationFactory.this.elements, ComponentCreatorImplementationFactory.this.types, ComponentCreatorImplementationFactory.this.metadataUtil)) {
                case NEW: {
                    com.google.common.base.Preconditions.checkState((boolean)requirement.kind().isModule());
                    factoryMethod.beginControlFlow("if ($N == null)", new Object[]{field}).addStatement("this.$N = $L", new Object[]{field, this.newModuleInstance(requirement)}).endControlFlow();
                    break;
                }
                case THROW: {
                    factoryMethod.addStatement("$T.checkBuilderRequirement($N, $T.class)", new Object[]{Preconditions.class, field, TypeNames.rawTypeName(field.type)});
                    break;
                }
            }
        }

        private void addNullHandlingForParameter(ComponentRequirement requirement, String parameter, MethodSpec.Builder factoryMethod) {
            if (!requirement.nullPolicy(ComponentCreatorImplementationFactory.this.elements, ComponentCreatorImplementationFactory.this.types, ComponentCreatorImplementationFactory.this.metadataUtil).equals((Object)ComponentRequirement.NullPolicy.ALLOW)) {
                factoryMethod.addStatement("$T.checkNotNull($L)", new Object[]{Preconditions.class, parameter});
            }
        }

        protected abstract MethodSpec.Builder factoryMethodBuilder();

        private CodeBlock componentConstructorArgs(ImmutableMap<ComponentRequirement, String> factoryMethodParameters) {
            return this.componentConstructorRequirements().stream().map(requirement -> {
                if (this.fields.containsKey(requirement)) {
                    return CodeBlock.of((String)"$N", (Object[])new Object[]{this.fields.get(requirement)});
                }
                if (factoryMethodParameters.containsKey(requirement)) {
                    return CodeBlock.of((String)"$L", (Object[])new Object[]{factoryMethodParameters.get(requirement)});
                }
                return this.newModuleInstance((ComponentRequirement)requirement);
            }).collect(CodeBlocks.toParametersCodeBlock());
        }

        private CodeBlock newModuleInstance(ComponentRequirement requirement) {
            com.google.common.base.Preconditions.checkArgument((boolean)requirement.kind().isModule());
            return ModuleProxies.newModuleInstance(requirement.typeElement(), this.className, ComponentCreatorImplementationFactory.this.elements);
        }
    }
}

