/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.graph.Traverser;
import dagger.internal.codegen.AutoValue_BindingGraph;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.ResolvedBindings;
import dagger.model.Key;
import dagger.model.RequestKind;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@AutoValue
abstract class BindingGraph {
    private static final Traverser<BindingGraph> SUBGRAPH_TRAVERSER = Traverser.forTree(BindingGraph::subgraphs);

    BindingGraph() {
    }

    abstract ComponentDescriptor componentDescriptor();

    abstract ImmutableMap<Key, ResolvedBindings> contributionBindings();

    abstract ImmutableMap<Key, ResolvedBindings> membersInjectionBindings();

    final ResolvedBindings resolvedBindings(BindingRequest request) {
        return request.isRequestKind(RequestKind.MEMBERS_INJECTION) ? (ResolvedBindings)this.membersInjectionBindings().get((Object)request.key()) : (ResolvedBindings)this.contributionBindings().get((Object)request.key());
    }

    final Iterable<ResolvedBindings> resolvedBindings() {
        return Iterables.concat((Iterable)this.membersInjectionBindings().values(), (Iterable)this.contributionBindings().values());
    }

    abstract ImmutableList<BindingGraph> subgraphs();

    TypeElement componentTypeElement() {
        return this.componentDescriptor().typeElement();
    }

    abstract ImmutableSet<ModuleDescriptor> ownedModules();

    ImmutableSet<TypeElement> ownedModuleTypes() {
        return FluentIterable.from(this.ownedModules()).transform(ModuleDescriptor::moduleElement).toSet();
    }

    abstract Optional<ExecutableElement> factoryMethod();

    ImmutableMap<ComponentRequirement, VariableElement> factoryMethodParameters() {
        Preconditions.checkState((boolean)this.factoryMethod().isPresent());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (VariableElement variableElement : this.factoryMethod().get().getParameters()) {
            builder.put((Object)ComponentRequirement.forModule(variableElement.asType()), (Object)variableElement);
        }
        return builder.build();
    }

    ImmutableSet<ComponentRequirement> componentRequirements() {
        ImmutableSet<TypeElement> requiredModules = this.requiredModuleElements();
        ImmutableSet.Builder requirements = ImmutableSet.builder();
        this.componentDescriptor().requirements().stream().filter(requirement -> !requirement.kind().isModule() || requiredModules.contains((Object)requirement.typeElement())).forEach(arg_0 -> ((ImmutableSet.Builder)requirements).add(arg_0));
        if (this.factoryMethod().isPresent()) {
            requirements.addAll((Iterable)this.factoryMethodParameters().keySet());
        }
        return requirements.build();
    }

    private ImmutableSet<TypeElement> requiredModuleElements() {
        return DaggerStreams.stream(SUBGRAPH_TRAVERSER.depthFirstPostOrder((Object)this)).flatMap(graph -> graph.contributionBindings().values().stream()).flatMap(bindings -> bindings.contributionBindings().stream()).map(BindingDeclaration::contributingModule).distinct().flatMap(DaggerStreams.presentValues()).filter(arg_0 -> this.ownedModuleTypes().contains(arg_0)).collect(DaggerStreams.toImmutableSet());
    }

    ImmutableSet<ComponentDescriptor> componentDescriptors() {
        return FluentIterable.from((Iterable)SUBGRAPH_TRAVERSER.depthFirstPreOrder((Object)this)).transform(BindingGraph::componentDescriptor).toSet();
    }

    abstract boolean isFullBindingGraph();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    static BindingGraph create(ComponentDescriptor componentDescriptor, ImmutableMap<Key, ResolvedBindings> resolvedContributionBindingsMap, ImmutableMap<Key, ResolvedBindings> resolvedMembersInjectionBindings, ImmutableList<BindingGraph> subgraphs, ImmutableSet<ModuleDescriptor> ownedModules, Optional<ExecutableElement> factoryMethod, boolean isFullBindingGraph) {
        BindingGraph.checkForDuplicates(subgraphs);
        return new AutoValue_BindingGraph(componentDescriptor, resolvedContributionBindingsMap, resolvedMembersInjectionBindings, subgraphs, ownedModules, factoryMethod, isFullBindingGraph);
    }

    private static final void checkForDuplicates(Iterable<BindingGraph> graphs) {
        Map duplicateGraphs = Maps.filterValues((Map)Multimaps.index(graphs, graph -> graph.componentDescriptor().typeElement()).asMap(), overlapping -> overlapping.size() > 1);
        if (!duplicateGraphs.isEmpty()) {
            throw new IllegalArgumentException("Expected no duplicates: " + duplicateGraphs);
        }
    }
}

