/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.AutoValue_ComponentDescriptor;
import dagger.internal.codegen.ComponentAnnotation;
import dagger.internal.codegen.ComponentCreatorAnnotation;
import dagger.internal.codegen.ComponentCreatorDescriptor;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequestFactory;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.ModuleAnnotation;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.Scopes;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.model.Scope;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class ComponentDescriptorFactory {
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final DependencyRequestFactory dependencyRequestFactory;
    private final ModuleDescriptor.Factory moduleDescriptorFactory;

    @Inject
    ComponentDescriptorFactory(DaggerElements elements, DaggerTypes types, DependencyRequestFactory dependencyRequestFactory, ModuleDescriptor.Factory moduleDescriptorFactory) {
        this.elements = elements;
        this.types = types;
        this.dependencyRequestFactory = dependencyRequestFactory;
        this.moduleDescriptorFactory = moduleDescriptorFactory;
    }

    ComponentDescriptor rootComponentDescriptor(TypeElement typeElement) {
        return this.create(typeElement, (ComponentAnnotation)ComponentDescriptorFactory.checkAnnotation(typeElement, ComponentAnnotation::rootComponentAnnotation, "must have a component annotation"));
    }

    ComponentDescriptor subcomponentDescriptor(TypeElement typeElement) {
        return this.create(typeElement, (ComponentAnnotation)ComponentDescriptorFactory.checkAnnotation(typeElement, ComponentAnnotation::subcomponentAnnotation, "must have a subcomponent annotation"));
    }

    ComponentDescriptor moduleComponentDescriptor(TypeElement typeElement) {
        return this.create(typeElement, ComponentAnnotation.fromModuleAnnotation((ModuleAnnotation)ComponentDescriptorFactory.checkAnnotation(typeElement, ModuleAnnotation::moduleAnnotation, "must have a module annotation")));
    }

    private static <A> A checkAnnotation(TypeElement typeElement, Function<TypeElement, Optional<A>> annotationFunction, String message) {
        return annotationFunction.apply(typeElement).orElseThrow(() -> new IllegalArgumentException(typeElement + " " + message));
    }

    private ComponentDescriptor create(TypeElement typeElement, ComponentAnnotation componentAnnotation) {
        ImmutableSet enclosedCreators;
        DeclaredType declaredComponentType = MoreTypes.asDeclared(typeElement.asType());
        ImmutableSet componentDependencies = componentAnnotation.dependencyTypes().stream().map(ComponentRequirement::forDependency).collect(DaggerStreams.toImmutableSet());
        ImmutableMap.Builder dependenciesByDependencyMethod = ImmutableMap.builder();
        for (ComponentRequirement componentDependency : componentDependencies) {
            for (Object dependencyMethod : ElementFilter.methodsIn(this.elements.getAllMembers(componentDependency.typeElement()))) {
                if (!ComponentDescriptor.isComponentContributionMethod(this.elements, (ExecutableElement)dependencyMethod)) continue;
                dependenciesByDependencyMethod.put(dependencyMethod, (Object)componentDependency);
            }
        }
        ImmutableSet modules = componentAnnotation.isRealComponent() ? componentAnnotation.modules() : ImmutableSet.of((Object)typeElement);
        ImmutableSet<ModuleDescriptor> transitiveModules = this.moduleDescriptorFactory.transitiveModules((Iterable<TypeElement>)modules);
        ImmutableSet.Builder subcomponentsFromModules = ImmutableSet.builder();
        for (ModuleDescriptor module : transitiveModules) {
            for (SubcomponentDeclaration subcomponentDeclaration : module.subcomponentDeclarations()) {
                TypeElement subcomponent2 = subcomponentDeclaration.subcomponentType();
                subcomponentsFromModules.add((Object)this.subcomponentDescriptor(subcomponent2));
            }
        }
        ImmutableSet.Builder componentMethodsBuilder = ImmutableSet.builder();
        ImmutableBiMap.Builder subcomponentsByFactoryMethod = ImmutableBiMap.builder();
        ImmutableBiMap.Builder subcomponentsByBuilderMethod = ImmutableBiMap.builder();
        if (componentAnnotation.isRealComponent()) {
            ImmutableSet<ExecutableElement> unimplementedMethods = this.elements.getUnimplementedMethods(typeElement);
            for (ExecutableElement componentMethod : unimplementedMethods) {
                ComponentDescriptor.ComponentMethodDescriptor componentMethodDescriptor = this.getDescriptorForComponentMethod(typeElement, componentAnnotation, componentMethod);
                componentMethodsBuilder.add((Object)componentMethodDescriptor);
                componentMethodDescriptor.subcomponent().ifPresent(subcomponent -> {
                    if (componentMethodDescriptor.dependencyRequest().isPresent()) {
                        subcomponentsByBuilderMethod.put((Object)componentMethodDescriptor, subcomponent);
                    } else {
                        subcomponentsByFactoryMethod.put((Object)componentMethodDescriptor, subcomponent);
                    }
                });
            }
        }
        Optional<ComponentCreatorDescriptor> creatorDescriptor = (enclosedCreators = ComponentCreatorAnnotation.creatorAnnotationsFor(componentAnnotation).stream().flatMap(creatorAnnotation -> ConfigurationAnnotations.enclosedAnnotatedTypes(typeElement, creatorAnnotation).stream()).collect(DaggerStreams.toImmutableSet())).isEmpty() ? Optional.empty() : Optional.of(ComponentCreatorDescriptor.create((DeclaredType)Iterables.getOnlyElement(enclosedCreators), this.elements, this.types, this.dependencyRequestFactory));
        ImmutableSet scopes = Scopes.scopesOf(typeElement);
        if (componentAnnotation.isProduction()) {
            scopes = ImmutableSet.builder().addAll(scopes).add((Object)Scopes.productionScope(this.elements)).build();
        }
        return new AutoValue_ComponentDescriptor(componentAnnotation, typeElement, componentDependencies, transitiveModules, (ImmutableMap<ExecutableElement, ComponentRequirement>)dependenciesByDependencyMethod.build(), (ImmutableSet<Scope>)scopes, (ImmutableSet<ComponentDescriptor>)subcomponentsFromModules.build(), (ImmutableBiMap<ComponentDescriptor.ComponentMethodDescriptor, ComponentDescriptor>)subcomponentsByFactoryMethod.build(), (ImmutableBiMap<ComponentDescriptor.ComponentMethodDescriptor, ComponentDescriptor>)subcomponentsByBuilderMethod.build(), (ImmutableSet<ComponentDescriptor.ComponentMethodDescriptor>)componentMethodsBuilder.build(), creatorDescriptor);
    }

    private ComponentDescriptor.ComponentMethodDescriptor getDescriptorForComponentMethod(TypeElement componentElement, ComponentAnnotation componentAnnotation, ExecutableElement componentMethod) {
        ComponentDescriptor.ComponentMethodDescriptor.Builder descriptor = ComponentDescriptor.ComponentMethodDescriptor.builder(componentMethod);
        ExecutableType resolvedComponentMethod = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(componentElement.asType()), componentMethod));
        TypeMirror returnType = resolvedComponentMethod.getReturnType();
        if (returnType.getKind().equals((Object)TypeKind.DECLARED) && !InjectionAnnotations.getQualifier(componentMethod).isPresent()) {
            TypeElement returnTypeElement = MoreTypes.asTypeElement(returnType);
            if (ComponentAnnotation.subcomponentAnnotation(returnTypeElement).isPresent()) {
                return descriptor.subcomponent(this.subcomponentDescriptor(returnTypeElement)).build();
            }
            if (ConfigurationAnnotations.isSubcomponentCreator(returnTypeElement)) {
                descriptor.subcomponent(this.subcomponentDescriptor(MoreElements.asType(returnTypeElement.getEnclosingElement())));
            }
        }
        switch (componentMethod.getParameters().size()) {
            case 0: {
                Preconditions.checkArgument((!returnType.getKind().equals((Object)TypeKind.VOID) ? 1 : 0) != 0, (String)"component method cannot be void: %s", (Object)componentMethod);
                descriptor.dependencyRequest(componentAnnotation.isProduction() ? this.dependencyRequestFactory.forComponentProductionMethod(componentMethod, resolvedComponentMethod) : this.dependencyRequestFactory.forComponentProvisionMethod(componentMethod, resolvedComponentMethod));
                break;
            }
            case 1: {
                Preconditions.checkArgument((returnType.getKind().equals((Object)TypeKind.VOID) || MoreTypes.equivalence().equivalent((Object)returnType, (Object)resolvedComponentMethod.getParameterTypes().get(0)) ? 1 : 0) != 0, (String)"members injection method must return void or parameter type: %s", (Object)componentMethod);
                descriptor.dependencyRequest(this.dependencyRequestFactory.forComponentMembersInjectionMethod(componentMethod, resolvedComponentMethod));
                break;
            }
            default: {
                throw new IllegalArgumentException("component method has too many parameters: " + componentMethod);
            }
        }
        return descriptor.build();
    }
}

